/*
 * Decompiled with CFR 0.152.
 */
package org.apache.royale.compiler.internal.tree.mxml;

import java.util.List;
import org.apache.royale.compiler.common.ISourceLocation;
import org.apache.royale.compiler.definitions.IClassDefinition;
import org.apache.royale.compiler.definitions.IDefinition;
import org.apache.royale.compiler.definitions.IVariableDefinition;
import org.apache.royale.compiler.internal.definitions.ClassDefinition;
import org.apache.royale.compiler.internal.parsing.ISourceFragment;
import org.apache.royale.compiler.internal.projects.RoyaleProject;
import org.apache.royale.compiler.internal.tree.as.NodeBase;
import org.apache.royale.compiler.internal.tree.mxml.MXMLArrayNode;
import org.apache.royale.compiler.internal.tree.mxml.MXMLClassNode;
import org.apache.royale.compiler.internal.tree.mxml.MXMLInstanceNode;
import org.apache.royale.compiler.internal.tree.mxml.MXMLNodeBase;
import org.apache.royale.compiler.internal.tree.mxml.MXMLTreeBuilder;
import org.apache.royale.compiler.mxml.IMXMLTagData;
import org.apache.royale.compiler.mxml.IMXMLUnitData;
import org.apache.royale.compiler.tree.ASTNodeID;
import org.apache.royale.compiler.tree.as.IASNode;
import org.apache.royale.compiler.tree.mxml.IMXMLClassNode;
import org.apache.royale.compiler.tree.mxml.IMXMLDeferredInstanceNode;
import org.apache.royale.compiler.tree.mxml.IMXMLInstanceNode;

class MXMLDeferredInstanceNode
extends MXMLInstanceNode
implements IMXMLDeferredInstanceNode {
    private IMXMLInstanceNode childNode;

    MXMLDeferredInstanceNode(NodeBase parent) {
        super(parent);
    }

    @Override
    public ASTNodeID getNodeID() {
        return ASTNodeID.MXMLDeferredInstanceID;
    }

    @Override
    public IASNode getChild(int i) {
        return i == 0 ? this.childNode : null;
    }

    @Override
    public int getChildCount() {
        return this.childNode == null ? 0 : 1;
    }

    @Override
    protected void processChildTag(MXMLTreeBuilder builder, IMXMLTagData tag, IMXMLTagData childTag, MXMLNodeBase.MXMLNodeInfo info) {
        RoyaleProject project = builder.getProject();
        IDefinition definition = builder.getFileScope().resolveTagToDefinition(childTag);
        if (definition instanceof ClassDefinition) {
            String qname = project.getDeferredInstanceFromFunctionClass();
            this.setClassReference(project, qname);
            builder.addExpressionDependency(qname);
            this.childNode = MXMLInstanceNode.createInstanceNode(builder, definition.getQualifiedName(), this);
            ((MXMLInstanceNode)this.childNode).setClassReference(project, (ClassDefinition)definition);
            ((MXMLInstanceNode)this.childNode).initializeFromTag(builder, childTag);
        }
    }

    void initializeDefaultProperty(MXMLTreeBuilder builder, IVariableDefinition defaultPropertyDefinition, List<IMXMLUnitData> contentUnits) {
        String instanceType;
        RoyaleProject project = builder.getProject();
        assert (contentUnits.isEmpty() || !builder.getFileScope().isScriptTag(contentUnits.get(0))) : "Script tags should not start a default property!";
        assert (contentUnits.isEmpty() || !builder.getFileScope().isScriptTag(contentUnits.get(contentUnits.size() - 1))) : "Trailing script tags should be removed from default property content units!";
        this.setLocation(builder, contentUnits);
        this.setClassReference(project, project.getDeferredInstanceFromFunctionClass());
        boolean isSingleArrayTag = false;
        int n = contentUnits.size();
        if (n == 1 && contentUnits.get(0) instanceof IMXMLTagData) {
            IMXMLTagData tag = (IMXMLTagData)contentUnits.get(0);
            IDefinition definition = builder.getFileScope().resolveTagToDefinition(tag);
            isSingleArrayTag = definition.getQualifiedName().equals("Array");
        }
        if ("Array".equals(instanceType = defaultPropertyDefinition.getInstanceType(project)) && !isSingleArrayTag) {
            this.childNode = new MXMLArrayNode(this);
            ((MXMLArrayNode)this.childNode).initializeDefaultProperty(builder, defaultPropertyDefinition, contentUnits);
        } else if (n == 1 && !isSingleArrayTag) {
            IMXMLTagData tag = (IMXMLTagData)contentUnits.get(0);
            IDefinition type = builder.getFileScope().resolveTagToDefinition(tag);
            if (type instanceof ClassDefinition) {
                IClassDefinition tagClass = (IClassDefinition)type;
                MXMLInstanceNode childInstanceNode = MXMLInstanceNode.createInstanceNode(builder, type.getQualifiedName(), this);
                childInstanceNode.setClassReference(project, tagClass);
                this.childNode = childInstanceNode;
                childInstanceNode.initializeFromTag(builder, tag);
            }
        }
    }

    @Override
    protected void initializationComplete(MXMLTreeBuilder builder, IMXMLTagData tag, MXMLNodeBase.MXMLNodeInfo info) {
        if (this.childNode == null) {
            ISourceLocation location = info.getSourceLocation();
            if (location == null) {
                location = tag.getLocationOfChildUnits();
            }
            ISourceFragment[] sourceFragments = info.getSourceFragments();
            this.initializeFromFragments(builder, location, sourceFragments);
        }
    }

    public void initializeFromFragments(MXMLTreeBuilder builder, ISourceLocation location, ISourceFragment[] fragments) {
        RoyaleProject project = builder.getProject();
        String qname = project.getDeferredInstanceFromClassClass();
        this.setClassReference(project, qname);
        builder.addExpressionDependency(qname);
        this.childNode = new MXMLClassNode(this);
        ((MXMLClassNode)this.childNode).setClassReference(project, this.childNode.getName());
        ((MXMLClassNode)this.childNode).initializeFromFragments(builder, location, fragments);
    }

    @Override
    public IMXMLClassNode getClassNode() {
        return this.childNode instanceof IMXMLClassNode ? (IMXMLClassNode)this.childNode : null;
    }

    @Override
    public IMXMLInstanceNode getInstanceNode() {
        return !(this.childNode instanceof IMXMLClassNode) ? this.childNode : null;
    }
}

