/*
 * Decompiled with CFR 0.152.
 */
package org.apache.royale.test.ant.launcher.commands.player;

import java.io.File;
import org.apache.royale.test.ant.launcher.OperatingSystem;
import org.apache.royale.test.ant.launcher.commands.player.AdlCommand;
import org.apache.royale.test.ant.launcher.commands.player.CustomPlayerCommand;
import org.apache.royale.test.ant.launcher.commands.player.DefaultPlayerCommand;
import org.apache.royale.test.ant.launcher.commands.player.FlashPlayerCommand;
import org.apache.royale.test.ant.launcher.commands.player.PlayerCommand;
import org.apache.royale.test.ant.launcher.platforms.LinuxDefaults;
import org.apache.royale.test.ant.launcher.platforms.MacOSXDefaults;
import org.apache.royale.test.ant.launcher.platforms.WindowsDefaults;

public class PlayerCommandFactory {
    public static PlayerCommand createPlayer(OperatingSystem os, String player, File customCommand, boolean localTrusted) {
        PlayerCommand newInstance = null;
        DefaultPlayerCommand defaultInstance = null;
        if (player.equals("flash") || player.equals("html")) {
            FlashPlayerCommand fpCommand = new FlashPlayerCommand();
            fpCommand.setLocalTrusted(localTrusted);
            defaultInstance = fpCommand;
        } else {
            defaultInstance = new AdlCommand();
        }
        if (os.equals((Object)OperatingSystem.WINDOWS)) {
            defaultInstance.setDefaults(new WindowsDefaults());
        } else if (os.equals((Object)OperatingSystem.MACOSX)) {
            defaultInstance.setDefaults(new MacOSXDefaults());
        } else {
            defaultInstance.setDefaults(new LinuxDefaults());
        }
        if (customCommand != null) {
            CustomPlayerCommand customInstance = new CustomPlayerCommand();
            customInstance.setProxiedCommand(defaultInstance);
            customInstance.setExecutable(customCommand);
            newInstance = customInstance;
        } else {
            newInstance = defaultInstance;
        }
        return newInstance;
    }
}

