/*
 * Decompiled with CFR 0.152.
 */
package org.apache.royale.formatter.config;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.royale.compiler.exceptions.ConfigurationException;
import org.apache.royale.compiler.internal.config.localization.ILocalizer;
import org.apache.royale.compiler.internal.config.localization.LocalizationManager;
import org.apache.royale.compiler.internal.config.localization.ResourceBundleLocalizer;
import org.apache.royale.compiler.problems.ConfigurationProblem;
import org.apache.royale.compiler.problems.ICompilerProblem;
import org.apache.royale.formatter.config.CommandLineConfigurator;
import org.apache.royale.formatter.config.Configuration;
import org.apache.royale.formatter.config.ConfigurationBuffer;
import org.apache.royale.formatter.config.ConfigurationValue;
import org.apache.royale.formatter.config.SystemPropertyConfigurator;
import org.apache.royale.utils.FilenameNormalization;
import org.apache.royale.utils.Trace;

public class Configurator
implements Cloneable {
    private static final String EQUALS_STRING = "=";
    private static final String PLUS_EQUALS_STRING = "+=";
    private static final String COMMA_STRING = ",";
    private static final String PLUS_STRING = "+";
    private ConfigurationBuffer cfgbuf;
    protected Configuration configuration;
    private Class<? extends Configuration> configurationClass;
    private Map<String, Object> args;
    private Map<String, Object> more;
    private String[] extras;
    private String configurationDefaultVariable;
    private Map<String, String> tokens;
    private boolean isConfigurationDirty;
    private boolean configurationSuccess;
    protected Collection<ICompilerProblem> configurationProblems;

    public static List<File> toFiles(List<String> paths) {
        ArrayList<File> result = new ArrayList<File>();
        for (String path : paths) {
            if (path == null) continue;
            result.add(new File(path));
        }
        return result;
    }

    public static List<File> toFileList(List<String> paths) {
        ArrayList<File> result = new ArrayList<File>();
        for (String path : paths) {
            if (path == null) continue;
            result.add(FilenameNormalization.normalize((File)new File(path)));
        }
        return result;
    }

    public static String[] toPaths(File[] files) {
        ArrayList<String> result = new ArrayList<String>();
        for (File file : files) {
            if (file == null) continue;
            result.add(file.getAbsolutePath());
        }
        return result.toArray(new String[0]);
    }

    public Configurator() {
        this(Configuration.class);
    }

    public Configurator(Class<? extends Configuration> configurationClass) {
        this.configurationClass = configurationClass;
        this.args = new LinkedHashMap<String, Object>();
        this.more = new LinkedHashMap<String, Object>();
        this.tokens = new TreeMap<String, String>();
        this.isConfigurationDirty = true;
        this.configurationDefaultVariable = "files";
        this.configurationProblems = new ArrayList<ICompilerProblem>();
        LocalizationManager.get().addLocalizer((ILocalizer)new ResourceBundleLocalizer());
    }

    public Collection<ICompilerProblem> validateConfiguration(String[] args) {
        if (args == null) {
            throw new NullPointerException("args may not be null");
        }
        ArrayList<ICompilerProblem> problems = new ArrayList<ICompilerProblem>();
        ConfigurationBuffer configurationBuffer = this.createConfigurationBuffer(this.configurationClass);
        try {
            CommandLineConfigurator.parse(configurationBuffer, null, args);
        }
        catch (ConfigurationException e) {
            ConfigurationProblem problem = new ConfigurationProblem(e);
            problems.add((ICompilerProblem)problem);
        }
        return problems;
    }

    public Collection<ICompilerProblem> getConfigurationProblems() {
        assert (this.configuration != null) : "Get the configuration problems after calling getConfiguration()";
        ArrayList<ICompilerProblem> problems = new ArrayList<ICompilerProblem>(this.configurationProblems.size() + this.configuration.getConfigurationProblems().size());
        problems.addAll(this.configurationProblems);
        problems.addAll(this.configuration.getConfigurationProblems());
        return problems;
    }

    public Configuration getConfiguration() {
        this.processConfiguration();
        return this.configuration;
    }

    public ConfigurationBuffer getConfigurationBuffer() {
        return this.cfgbuf;
    }

    protected Configuration createConfiguration() {
        try {
            return this.configurationClass.newInstance();
        }
        catch (Exception e) {
            this.reportConfigurationException((ConfigurationException)new ConfigurationException.CouldNotInstantiate(this.configurationClass.getName()));
            try {
                return (Configuration)Configuration.class.newInstance();
            }
            catch (Exception e2) {
                assert (false);
                return null;
            }
        }
    }

    protected void initializeConfiguration() {
        this.configuration = this.createConfiguration();
        this.cfgbuf = this.createConfigurationBuffer(this.configuration.getClass());
    }

    protected ConfigurationBuffer createConfigurationBuffer(Class<? extends Configuration> configurationClass) {
        return new ConfigurationBuffer(configurationClass, Configuration.getAliases());
    }

    protected boolean processConfiguration() {
        boolean success = true;
        if (this.isConfigurationDirty) {
            this.configurationProblems.clear();
            try {
                success = this.processConfiguration(this.getOptions(this.args, this.more, this.processExtras(this.extras)));
            }
            catch (ConfigurationException e) {
                this.reportConfigurationException(e);
                success = false;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else {
            success = this.configurationSuccess;
        }
        this.isConfigurationDirty = false;
        this.configurationSuccess = success;
        return success;
    }

    protected boolean processConfiguration(String[] argsArray) {
        this.initializeConfiguration();
        boolean success = true;
        try {
            SystemPropertyConfigurator.load(this.cfgbuf, "royale");
            CommandLineConfigurator.parse(this.cfgbuf, this.configurationDefaultVariable, argsArray);
            this.overrideDefaults();
            if (this.cfgbuf.getVar("version") != null) {
                return false;
            }
            List<ConfigurationValue> helpVar = this.cfgbuf.getVar("help");
            if (helpVar != null) {
                return false;
            }
            this.cfgbuf.clearSourceVars("command line");
            CommandLineConfigurator.parse(this.cfgbuf, this.configurationDefaultVariable, argsArray);
            if (!this.cfgbuf.commit(this.configuration, this.configurationProblems)) {
                success = false;
            }
            this.configuration.validate(this.cfgbuf);
        }
        catch (ConfigurationException e) {
            this.reportConfigurationException(e);
            success = false;
        }
        return success;
    }

    protected void overrideDefaults() throws ConfigurationException {
    }

    protected void reportConfigurationException(ConfigurationException e) {
        ConfigurationProblem problem = new ConfigurationProblem(e);
        this.configurationProblems.add((ICompilerProblem)problem);
    }

    protected String[] getOptions(Map<String, Object> args, Map<String, Object> more, String[] extras) {
        Object v;
        String k;
        Map m;
        Object value;
        String key;
        ArrayList<String> buffer = new ArrayList<String>();
        for (Map.Entry<String, String> tokenEntry : this.tokens.entrySet()) {
            buffer.add(PLUS_STRING + tokenEntry.getKey() + EQUALS_STRING + tokenEntry.getValue());
        }
        for (Map.Entry<String, Object> arg : args.entrySet()) {
            key = arg.getKey();
            value = arg.getValue();
            if (value instanceof Boolean) {
                buffer.add(key + EQUALS_STRING + value);
                continue;
            }
            if (value instanceof Number) {
                buffer.add(key);
                buffer.add(value.toString());
                continue;
            }
            if (value instanceof String) {
                if (!"".equals(value)) {
                    buffer.add(key);
                    buffer.add((String)value);
                    continue;
                }
                buffer.add(key + EQUALS_STRING);
                continue;
            }
            if (value instanceof File) {
                String p = ((File)value).getPath();
                if (!"".equals(p)) {
                    buffer.add(key);
                    buffer.add(p);
                    continue;
                }
                buffer.add(key + EQUALS_STRING);
                continue;
            }
            if (value instanceof Date) {
                buffer.add(key);
                buffer.add(value.toString());
                continue;
            }
            if (value instanceof Map) {
                m = (Map)value;
                for (Map.Entry entry : m.entrySet()) {
                    k = (String)entry.getKey();
                    v = entry.getValue();
                    if (v instanceof String) {
                        buffer.add(key);
                        buffer.add(k);
                        buffer.add((String)v);
                        continue;
                    }
                    if (v instanceof File) {
                        buffer.add(key);
                        buffer.add(k);
                        buffer.add(((File)v).getPath());
                        continue;
                    }
                    if (v instanceof Collection) {
                        buffer.add(key);
                        buffer.add(k);
                        Collection list = (Collection)v;
                        for (Object next : list) {
                            if (next == null) continue;
                            buffer.add(next.toString());
                        }
                        continue;
                    }
                    if (v != null) assert (false);
                }
                continue;
            }
            if (value instanceof int[]) {
                int[] a = (int[])value;
                buffer.add(key);
                buffer.add(String.valueOf(a[0]));
                buffer.add(String.valueOf(a[1]));
                continue;
            }
            if (value instanceof Collection) {
                LinkedList list = new LinkedList((Collection)args.get(key));
                int length = list.size();
                if (length > 0) {
                    buffer.add(key);
                }
                for (Object obj : list) {
                    if (obj instanceof String) {
                        buffer.add((String)obj);
                        continue;
                    }
                    if (!(obj instanceof File)) continue;
                    buffer.add(((File)obj).getPath());
                }
                continue;
            }
            if (value != null) assert (false);
        }
        for (Map.Entry<String, Object> moreEntry : more.entrySet()) {
            key = moreEntry.getKey();
            value = moreEntry.getValue();
            if (value instanceof Collection) {
                buffer.add(key + PLUS_EQUALS_STRING + this.toCommaSeparatedString((Collection)value));
                continue;
            }
            if (value instanceof Map) {
                m = (Map)value;
                for (Map.Entry entry : m.entrySet()) {
                    k = (String)entry.getKey();
                    v = entry.getValue();
                    if (v instanceof Collection) {
                        buffer.add(key + PLUS_EQUALS_STRING + k + COMMA_STRING + this.toCommaSeparatedString((Collection)v));
                        continue;
                    }
                    if (v != null) assert (false);
                }
                continue;
            }
            if (value != null) assert (false);
        }
        if (extras != null && extras.length > 0) {
            int length;
            int n = length = extras == null ? 0 : extras.length;
            for (int i = 0; i < length; ++i) {
                if (extras[i] == null) continue;
                buffer.add(extras[i]);
            }
        }
        String[] options = new String[buffer.size()];
        buffer.toArray(options);
        if (Trace.config) {
            Trace.trace((String)("Configurator: options = " + buffer.toString()));
        }
        return options;
    }

    protected String[] processExtras(String[] extraOptions) throws ConfigurationException {
        return extraOptions;
    }

    public void setConfiguration(String[] args, String defaultVariable) {
        this.extras = args;
        this.configurationDefaultVariable = defaultVariable;
        this.isConfigurationDirty = true;
    }

    public void setToken(String name, String value) {
        this.tokens.put(name, value);
        this.isConfigurationDirty = true;
    }

    public String toString() {
        String[] options;
        try {
            options = this.getOptions(this.args, this.more, this.processExtras(this.extras));
        }
        catch (ConfigurationException e) {
            options = new String[]{};
        }
        StringBuilder b = new StringBuilder();
        for (int i = 0; i < options.length; ++i) {
            b.append(options[i]);
            b.append(' ');
        }
        return b.toString();
    }

    private String toCommaSeparatedString(Collection<?> values) {
        StringBuilder b = new StringBuilder();
        int length = values.size();
        int i = 0;
        for (Object value : values) {
            String valueString = null;
            if (value instanceof String) {
                valueString = (String)value;
            } else if (value instanceof File) {
                valueString = ((File)value).getPath();
            }
            if (valueString != null) {
                b.append(valueString);
            }
            if (i++ >= length - 1) continue;
            b.append(COMMA_STRING);
        }
        return b.toString();
    }

    public Configurator clone() {
        Configurator cloneConfig;
        try {
            cloneConfig = (Configurator)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
        cloneConfig.args = new LinkedHashMap<String, Object>(this.args);
        cloneConfig.more = new LinkedHashMap<String, Object>(this.more);
        cloneConfig.tokens = new LinkedHashMap<String, String>(this.tokens);
        cloneConfig.configurationClass = this.configurationClass;
        cloneConfig.isConfigurationDirty = true;
        if (this.extras != null) {
            cloneConfig.extras = new String[this.extras.length];
            System.arraycopy(this.extras, 0, cloneConfig.extras, 0, this.extras.length);
        }
        return cloneConfig;
    }
}

