/*
 * Decompiled with CFR 0.152.
 */
package org.apache.royale.compiler.tools.annotate;

import java.io.File;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.royale.compiler.tools.annotate.AnnotateClass;
import org.codehaus.plexus.compiler.util.scan.InclusionScanException;
import org.codehaus.plexus.compiler.util.scan.SimpleSourceInclusionScanner;
import org.codehaus.plexus.compiler.util.scan.mapping.SourceMapping;
import org.codehaus.plexus.compiler.util.scan.mapping.SuffixMapping;

@Mojo(name="add-class-annotation", defaultPhase=LifecyclePhase.PROCESS_SOURCES)
public class AnnotateClassesMojo
extends AbstractMojo {
    @Parameter
    protected Set<String> includes = new HashSet<String>();
    @Parameter
    protected Set<String> excludes = new HashSet<String>();
    @Parameter(defaultValue="${project.build.directory}/generated-sources")
    private File directory;
    @Parameter(property="annotation", required=true)
    private String annotation;
    @Parameter(property="dateStart", required=false)
    private String dateStart = "";
    @Parameter(property="dateEnd", required=false)
    private String dateEnd = "";

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void execute() throws MojoExecutionException {
        SuffixMapping mapping = new SuffixMapping("jbg", Collections.emptySet());
        SimpleSourceInclusionScanner scan = new SimpleSourceInclusionScanner(this.includes, this.excludes);
        scan.addSourceMapping((SourceMapping)mapping);
        try {
            Set candidates = scan.getIncludedSources(this.directory, null);
            for (File candidate : candidates) {
                try {
                    AnnotateClass.processFile(candidate, this.annotation, this.dateStart, this.dateEnd);
                }
                catch (AnnotateClass.AnnotateClassDeleteException e) {
                    throw new MojoExecutionException(e.getMessage());
                }
                catch (AnnotateClass.AnnotateClassRenameException e) {
                    throw new MojoExecutionException(e.getMessage());
                    return;
                }
            }
        }
        catch (InclusionScanException e) {
            throw new MojoExecutionException("Error scanning files to be processed.", (Exception)((Object)e));
        }
    }
}

