/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.huaweicloud.dashboard.monitor;

import com.netflix.config.DynamicPropertyFactory;
import com.netflix.hystrix.HystrixCircuitBreaker;
import com.netflix.hystrix.HystrixCommandKey;
import com.netflix.hystrix.HystrixCommandMetrics;
import com.netflix.hystrix.HystrixEventType;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Collection;
import org.apache.servicecomb.dashboard.client.model.InterfaceInfo;
import org.apache.servicecomb.dashboard.client.model.MonitorData;
import org.apache.servicecomb.huaweicloud.dashboard.monitor.model.MonitorDataProvider;

public class HealthMonitorDataProvider
implements MonitorDataProvider {
    @Override
    public boolean enabled() {
        return DynamicPropertyFactory.getInstance().getBooleanProperty("servicecomb.monitor.provider.bizkeeper.enabled", false).get();
    }

    @Override
    public void extractInterfaceInfo(MonitorData monitorData) {
        Collection instances = HystrixCommandMetrics.getInstances();
        if (instances.isEmpty()) {
            return;
        }
        for (HystrixCommandMetrics instance : instances) {
            this.appendInterfaceInfo(monitorData, instance);
        }
    }

    private void appendInterfaceInfo(MonitorData monitorData, HystrixCommandMetrics metrics) {
        InterfaceInfo interfaceInfo = new InterfaceInfo();
        int windowTime = (Integer)metrics.getProperties().metricsRollingStatisticalWindowInMilliseconds().get() / 1000;
        long successCount = metrics.getRollingCount(HystrixEventType.SUCCESS);
        long failureCount = metrics.getRollingCount(HystrixEventType.FAILURE);
        long semRejectCount = metrics.getRollingCount(HystrixEventType.SEMAPHORE_REJECTED);
        long threadRejectCount = metrics.getRollingCount(HystrixEventType.THREAD_POOL_REJECTED);
        long timeoutCount = metrics.getRollingCount(HystrixEventType.TIMEOUT);
        long shortCircuitedCount = metrics.getRollingCount(HystrixEventType.SHORT_CIRCUITED);
        long rollingErrorTotal = failureCount + semRejectCount + threadRejectCount + timeoutCount;
        long rollingTotal = successCount + rollingErrorTotal;
        if (rollingTotal == 0L) {
            interfaceInfo.setRate(1.0);
            interfaceInfo.setFailureRate(0.0);
        } else {
            double failurePercentage = (double)rollingErrorTotal / (double)rollingTotal;
            interfaceInfo.setRate(1.0 - failurePercentage);
            interfaceInfo.setFailureRate(failurePercentage);
        }
        int latency = metrics.getTotalTimeMean();
        int latency995 = metrics.getTotalTimePercentile(99.5);
        int latency99 = metrics.getTotalTimePercentile(99.0);
        int latency90 = metrics.getTotalTimePercentile(90.0);
        int latency75 = metrics.getTotalTimePercentile(75.0);
        int latency50 = metrics.getTotalTimePercentile(50.0);
        int latency25 = metrics.getTotalTimePercentile(25.0);
        int latency5 = metrics.getTotalTimePercentile(5.0);
        interfaceInfo.setName(metrics.getCommandKey().name());
        interfaceInfo.setCircuitBreakerOpen(this.isOpen(metrics));
        interfaceInfo.setShortCircuited(shortCircuitedCount);
        interfaceInfo.setFailureRate((double)failureCount);
        interfaceInfo.setSemaphoreRejected(semRejectCount);
        interfaceInfo.setThreadPoolRejected(threadRejectCount);
        interfaceInfo.setCountTimeout(timeoutCount);
        interfaceInfo.setDesc(metrics.getCommandKey().name());
        interfaceInfo.setLatency(latency);
        interfaceInfo.setL995(latency995);
        interfaceInfo.setL99(latency99);
        interfaceInfo.setL90(latency90);
        interfaceInfo.setL75(latency75);
        interfaceInfo.setL50(latency50);
        interfaceInfo.setL25(latency25);
        interfaceInfo.setL5(latency5);
        interfaceInfo.setTotal(rollingTotal);
        double qpsVal = (double)rollingTotal / (double)windowTime;
        BigDecimal b = new BigDecimal(qpsVal);
        BigDecimal qps = b.setScale(1, RoundingMode.HALF_DOWN);
        interfaceInfo.setQps(qps.doubleValue());
        monitorData.addInterfaceInfo(interfaceInfo);
    }

    private boolean isOpen(HystrixCommandMetrics metrics) {
        if (((Boolean)metrics.getProperties().circuitBreakerForceOpen().get()).booleanValue()) {
            return true;
        }
        if (((Boolean)metrics.getProperties().circuitBreakerForceClosed().get()).booleanValue()) {
            return false;
        }
        HystrixCircuitBreaker circuitBreaker = HystrixCircuitBreaker.Factory.getInstance((HystrixCommandKey)metrics.getCommandKey());
        return circuitBreaker != null && circuitBreaker.isOpen();
    }
}

