/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.foundation.protobuf.internal.schema.serializer.repeated.impl.longs;

import io.protostuff.compiler.model.Field;
import io.protostuff.runtime.FieldSchema;
import org.apache.servicecomb.foundation.protobuf.internal.ProtoUtils;
import org.apache.servicecomb.foundation.protobuf.internal.bean.PropertyDescriptor;
import org.apache.servicecomb.foundation.protobuf.internal.schema.serializer.repeated.AbstractPrimitiveWriters;
import org.apache.servicecomb.foundation.protobuf.internal.schema.serializer.repeated.RepeatedPrimitiveWriteSchemas;

public class Fixed64NotPackedWriteSchemas {
    public static <T> FieldSchema<T> create(Field protoField, PropertyDescriptor propertyDescriptor) {
        return RepeatedPrimitiveWriteSchemas.create(protoField, propertyDescriptor, new Fixed64NotPackedWriters(protoField));
    }

    private static class Fixed64NotPackedWriters
    extends AbstractPrimitiveWriters<long[], Long> {
        public Fixed64NotPackedWriters(Field protoField) {
            super(protoField);
            this.primitiveArrayWriter = (output, array) -> {
                for (long element : array) {
                    output.writeFixed64(this.tag, this.tagSize, element);
                }
            };
            this.arrayWriter = (output, array) -> {
                for (Long element : array) {
                    if (element != null) {
                        output.writeFixed64(this.tag, this.tagSize, element);
                        continue;
                    }
                    ProtoUtils.throwNotSupportNullElement(protoField);
                }
            };
            this.collectionWriter = (output, collection) -> {
                for (Long element : collection) {
                    if (element != null) {
                        output.writeFixed64(this.tag, this.tagSize, element);
                        continue;
                    }
                    ProtoUtils.throwNotSupportNullElement(protoField);
                }
            };
            this.stringArrayWriter = (output, array) -> {
                for (String element : array) {
                    if (element != null) {
                        long parsedValue = Long.parseLong(element, 10);
                        output.writeFixed64(this.tag, this.tagSize, parsedValue);
                        continue;
                    }
                    ProtoUtils.throwNotSupportNullElement(protoField);
                }
            };
        }
    }
}

