/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.zeroconfig.multicast;

import java.net.SocketTimeoutException;
import java.util.concurrent.Executors;
import org.apache.servicecomb.registry.lightweight.Message;
import org.apache.servicecomb.registry.lightweight.MessageExecutor;
import org.apache.servicecomb.zeroconfig.Config;
import org.apache.servicecomb.zeroconfig.multicast.Multicast;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class MulticastServer {
    private static final Logger LOGGER = LoggerFactory.getLogger(MulticastServer.class);
    private final Multicast multicast;
    private final MessageExecutor messageExecutor;

    public MulticastServer(Config config, Multicast multicast, MessageExecutor messageExecutor) {
        this.multicast = multicast;
        this.messageExecutor = messageExecutor;
        if (!config.isMulticast()) {
            return;
        }
        Executors.newSingleThreadExecutor(runnable -> new Thread(runnable, "multicast-server-recv")).execute(this::recv);
        messageExecutor.startCheckDeadInstances(config.getCheckDeadInstancesInterval());
    }

    private void recv() {
        while (true) {
            Message<?> message;
            if ((message = this.recvMsg()) == null) {
                continue;
            }
            this.messageExecutor.processMessage(message);
        }
    }

    private Message<?> recvMsg() {
        try {
            return this.multicast.recv();
        }
        catch (SocketTimeoutException ignore) {
            return null;
        }
        catch (Exception e) {
            LOGGER.error("failed to receive or decode message.", (Throwable)e);
            return null;
        }
    }
}

