/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.swagger.invocation.response;

import java.lang.reflect.Type;
import java.util.List;
import org.apache.servicecomb.foundation.common.utils.SPIServiceUtils;
import org.apache.servicecomb.swagger.invocation.response.ResponseMapperFactory;

public class ResponseMapperFactories<MAPPER> {
    private final List<ResponseMapperFactory<MAPPER>> factories;

    public ResponseMapperFactories(Class<? extends ResponseMapperFactory<MAPPER>> factoryCls) {
        this.factories = SPIServiceUtils.getSortedService(factoryCls);
    }

    public MAPPER createResponseMapper(Type providerType) {
        for (ResponseMapperFactory<MAPPER> factory : this.factories) {
            if (!factory.isMatch(providerType)) continue;
            return factory.createResponseMapper(this, providerType);
        }
        throw new IllegalStateException(String.format("can not find response mapper for %s, this should never happened.", providerType.getTypeName()));
    }
}

