/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.core.executor;

import java.util.concurrent.BlockingQueue;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.servicecomb.core.executor.LinkedBlockingQueueEx;

public class ThreadPoolExecutorEx
extends ThreadPoolExecutor {
    private final AtomicInteger submittedCount = new AtomicInteger();
    private final AtomicInteger finishedCount = new AtomicInteger();
    private final AtomicInteger rejectedCount = new AtomicInteger();

    public ThreadPoolExecutorEx(int coreThreads, int maxThreads, int maxIdleInSecond, TimeUnit timeUnit, BlockingQueue<Runnable> queue, ThreadFactory threadFactory) {
        super(coreThreads, maxThreads, (long)maxIdleInSecond, timeUnit, queue, threadFactory);
        if (queue instanceof LinkedBlockingQueueEx) {
            ((LinkedBlockingQueueEx)queue).setOwner(this);
        }
        this.setRejectedExecutionHandler(this::rejectedExecution);
    }

    @Override
    public void execute(Runnable command) {
        this.submittedCount.incrementAndGet();
        try {
            super.execute(command);
        }
        catch (RejectedExecutionException e) {
            if (this.getQueue() instanceof LinkedBlockingQueueEx) {
                LinkedBlockingQueueEx queue = (LinkedBlockingQueueEx)this.getQueue();
                if (!queue.force(command)) {
                    throw new RejectedExecutionException("thread pool queue is full");
                }
            }
            throw e;
        }
    }

    public void rejectedExecution(Runnable r, ThreadPoolExecutor e) {
        this.rejectedCount.incrementAndGet();
        this.finishedCount.incrementAndGet();
        throw new RejectedExecutionException("Task " + r.toString() + " rejected from " + e.toString());
    }

    @Override
    protected void afterExecute(Runnable r, Throwable t) {
        super.afterExecute(r, t);
        this.finishedCount.incrementAndGet();
    }

    public int getNotFinished() {
        return this.submittedCount.get() - this.finishedCount.get();
    }

    public int getRejectedCount() {
        return this.rejectedCount.get();
    }
}

