/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.foundation.vertx.stream;

import io.vertx.core.buffer.Buffer;
import jakarta.servlet.ReadListener;
import jakarta.servlet.ServletInputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;

public class BufferInputStream
extends ServletInputStream {
    private int readIndex = 0;
    private final Buffer byteBuf;

    public BufferInputStream(Buffer buffer) {
        this.byteBuf = buffer;
    }

    public long skip(long len) {
        int skipLen = Math.min((int)len, this.available());
        this.readIndex += skipLen;
        return skipLen;
    }

    public byte readByte() {
        int index = this.readIndex;
        this.readIndex = index + 1;
        return this.byteBuf.getByte(index);
    }

    public int read() {
        return this.readByte() & 0xFF;
    }

    public boolean readBoolean() {
        return this.readByte() != 0;
    }

    public short readShort() {
        int index = this.readIndex;
        this.readIndex = index + 2;
        return this.byteBuf.getShort(index);
    }

    public int readInt() {
        int index = this.readIndex;
        this.readIndex = index + 4;
        return this.byteBuf.getInt(index);
    }

    public long readLong() {
        int index = this.readIndex;
        this.readIndex = index + 8;
        return this.byteBuf.getLong(index);
    }

    public int getIndex() {
        return this.readIndex;
    }

    public String readString() {
        int length = this.readInt();
        byte[] bytes = new byte[length];
        int index = this.readIndex;
        this.readIndex = index + length;
        this.byteBuf.getBytes(index, this.readIndex, bytes);
        return new String(bytes, StandardCharsets.UTF_8);
    }

    public int read(byte[] b) {
        return this.read(b, 0, b.length);
    }

    public int read(byte[] b, int off, int len) {
        int avail = this.available();
        if (avail <= 0) {
            return -1;
        }
        if (len == 0) {
            return 0;
        }
        if (len > avail) {
            len = avail;
        }
        int index = this.readIndex;
        this.readIndex = index + len;
        this.byteBuf.getBytes(index, this.readIndex, b);
        return len;
    }

    public int available() {
        return this.byteBuf.length() - this.readIndex;
    }

    public void close() {
    }

    public void reset() throws IOException {
        this.readIndex = 0;
    }

    public Buffer getByteBuf() {
        return this.byteBuf;
    }

    public boolean isFinished() {
        return this.byteBuf.length() > this.readIndex;
    }

    public boolean isReady() {
        return true;
    }

    public void setReadListener(ReadListener readListener) {
    }
}

