/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.foundation.vertx.stream;

import io.vertx.core.Context;
import io.vertx.core.Handler;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.streams.ReadStream;
import io.vertx.core.streams.WriteStream;
import jakarta.servlet.http.Part;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.concurrent.CompletableFuture;
import org.apache.commons.io.IOUtils;
import org.apache.servicecomb.foundation.vertx.http.DownloadUtils;
import org.apache.servicecomb.foundation.vertx.http.ReadStreamPart;
import org.apache.servicecomb.foundation.vertx.stream.InputStreamToReadStream;
import org.apache.servicecomb.foundation.vertx.stream.OutputStreamToWriteStream;
import org.apache.servicecomb.foundation.vertx.stream.PumpCommon;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PumpFromPart {
    private static final Logger LOGGER = LoggerFactory.getLogger(PumpFromPart.class);
    private final Context context;
    private final Part part;

    public PumpFromPart(Context context, Part part) {
        this.context = context;
        this.part = part;
    }

    private CompletableFuture<ReadStream<Buffer>> prepareReadStream() {
        CompletableFuture<ReadStream<Buffer>> future = new CompletableFuture<ReadStream<Buffer>>();
        if (ReadStreamPart.class.isInstance(this.part)) {
            future.complete(((ReadStreamPart)this.part).getReadStream());
            return future;
        }
        try {
            InputStream inputStream = this.part.getInputStream();
            InputStreamToReadStream inputStreamToReadStream = new InputStreamToReadStream(this.context, inputStream, true);
            inputStreamToReadStream.pause();
            future.complete(inputStreamToReadStream);
        }
        catch (IOException e) {
            future.completeExceptionally(e);
        }
        return future;
    }

    public CompletableFuture<Void> toWriteStream(WriteStream<Buffer> writeStream, Handler<Throwable> throwableHandler) {
        return ((CompletableFuture)this.prepareReadStream().thenCompose(readStream -> new PumpCommon().pump(this.context, (ReadStream<Buffer>)readStream, writeStream, throwableHandler))).whenComplete((v, e) -> {
            if (e != null) {
                LOGGER.error("to write stream failed.", e);
            }
            DownloadUtils.clearPartResource(this.part);
            writeStream.drainHandler(null);
        });
    }

    public CompletableFuture<Void> toOutputStream(OutputStream outputStream, boolean autoCloseOutputStream) {
        if (this.context == null) {
            return this.toOutputStreamSync(outputStream, autoCloseOutputStream);
        }
        return this.toOutputStreamAsync(outputStream, autoCloseOutputStream);
    }

    private CompletableFuture<Void> toOutputStreamAsync(OutputStream outputStream, boolean autoCloseOutputStream) {
        OutputStreamToWriteStream outputStreamToWriteStream = new OutputStreamToWriteStream(this.context, outputStream, autoCloseOutputStream);
        return this.toWriteStream(outputStreamToWriteStream, null);
    }

    private CompletableFuture<Void> toOutputStreamSync(OutputStream outputStream, boolean autoCloseOutputStream) {
        CompletableFuture<Void> future = new CompletableFuture<Void>();
        future.whenComplete((v, e) -> DownloadUtils.clearPartResource(this.part));
        try (InputStream inputStream = this.part.getInputStream();){
            IOUtils.copyLarge((InputStream)inputStream, (OutputStream)outputStream);
        }
        catch (Throwable e2) {
            future.completeExceptionally(e2);
        }
        if (autoCloseOutputStream) {
            try {
                outputStream.close();
            }
            catch (Throwable e3) {
                future.completeExceptionally(e3);
            }
        }
        future.complete(null);
        return future;
    }
}

