/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.metrics.core;

import com.google.common.eventbus.EventBus;
import io.micrometer.core.instrument.MeterRegistry;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.concurrent.ThreadPoolExecutor;
import org.apache.servicecomb.core.SCBEngine;
import org.apache.servicecomb.core.definition.MicroserviceMeta;
import org.apache.servicecomb.core.definition.OperationMeta;
import org.apache.servicecomb.core.executor.GroupExecutor;
import org.apache.servicecomb.foundation.common.utils.BeanUtils;
import org.apache.servicecomb.foundation.metrics.MetricsBootstrapConfig;
import org.apache.servicecomb.foundation.metrics.MetricsInitializer;
import org.apache.servicecomb.foundation.metrics.meter.PeriodMeter;
import org.apache.servicecomb.metrics.core.meter.pool.ThreadPoolMeter;

public class ThreadPoolMetersInitializer
implements MetricsInitializer,
PeriodMeter {
    private MeterRegistry meterRegistry;
    private Map<String, ThreadPoolMeter> threadPoolMeters = new HashMap<String, ThreadPoolMeter>();

    public void init(MeterRegistry meterRegistry, EventBus eventBus, MetricsBootstrapConfig config) {
        this.meterRegistry = meterRegistry;
        this.createThreadPoolMeters();
    }

    public void createThreadPoolMeters() {
        Map<Executor, Executor> operationExecutors = this.collectionOperationExecutors();
        Map beanExecutors = BeanUtils.getContext().getBeansOfType(Executor.class);
        for (Map.Entry entry : beanExecutors.entrySet()) {
            Executor executor = (Executor)entry.getValue();
            if (!operationExecutors.containsKey(executor)) continue;
            if (executor instanceof GroupExecutor) {
                this.createThreadPoolMeters((String)entry.getKey(), (GroupExecutor)executor);
                continue;
            }
            this.createThreadPoolMeters((String)entry.getKey(), executor);
        }
    }

    protected Map<Executor, Executor> collectionOperationExecutors() {
        IdentityHashMap<Executor, Executor> operationExecutors = new IdentityHashMap<Executor, Executor>();
        MicroserviceMeta microserviceMeta = SCBEngine.getInstance().getProducerMicroserviceMeta();
        for (OperationMeta operationMeta : microserviceMeta.getOperations()) {
            operationExecutors.put(operationMeta.getExecutor(), operationMeta.getExecutor());
        }
        return operationExecutors;
    }

    protected void createThreadPoolMeters(String threadPoolName, GroupExecutor groupExecutor) {
        for (int idx = 0; idx < groupExecutor.getExecutorList().size(); ++idx) {
            Executor executor = (Executor)groupExecutor.getExecutorList().get(idx);
            this.createThreadPoolMeters(threadPoolName + "-group" + idx, executor);
        }
    }

    public void createThreadPoolMeters(String threadPoolName, Executor executor) {
        if (!(executor instanceof ThreadPoolExecutor)) {
            return;
        }
        ThreadPoolExecutor threadPoolExecutor = (ThreadPoolExecutor)executor;
        this.threadPoolMeters.computeIfAbsent(threadPoolName, key -> new ThreadPoolMeter(this.meterRegistry, threadPoolName, threadPoolExecutor));
    }

    public void poll(long msNow, long secondInterval) {
        this.threadPoolMeters.forEach((key, value) -> value.poll(msNow, secondInterval));
    }
}

