/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.transport.rest.vertx;

import com.google.common.eventbus.Subscribe;
import io.vertx.core.http.ServerWebSocket;
import jakarta.ws.rs.core.Response;
import java.util.HashMap;
import java.util.Map;
import org.apache.servicecomb.common.rest.EdgeServerWebSocketInvocationCreator;
import org.apache.servicecomb.common.rest.ProviderServerWebSocketInvocationCreator;
import org.apache.servicecomb.common.rest.route.URLMappedConfigurationItem;
import org.apache.servicecomb.common.rest.route.URLMappedConfigurationLoader;
import org.apache.servicecomb.common.rest.route.Utils;
import org.apache.servicecomb.config.ConfigurationChangedEvent;
import org.apache.servicecomb.core.Endpoint;
import org.apache.servicecomb.core.SCBEngine;
import org.apache.servicecomb.core.Transport;
import org.apache.servicecomb.core.definition.MicroserviceMeta;
import org.apache.servicecomb.core.invocation.InvocationCreator;
import org.apache.servicecomb.foundation.common.LegacyPropertyFactory;
import org.apache.servicecomb.foundation.common.event.EventManager;
import org.apache.servicecomb.swagger.invocation.exception.CommonExceptionData;
import org.apache.servicecomb.swagger.invocation.exception.InvocationException;
import org.apache.servicecomb.transport.rest.vertx.TransportConfig;
import org.apache.servicecomb.transport.rest.vertx.WebSocketProducerInvocationFlow;
import org.springframework.core.env.Environment;

public class WebSocketDispatcher {
    private static final String KEY_MAPPING_PREFIX = "servicecomb.http.dispatcher.edge.websocket.mappings";
    private final Object LOCK = new Object();
    private volatile boolean initialized = false;
    private Endpoint endpoint;
    private MicroserviceMeta microserviceMeta;
    private boolean isEdge;
    private Map<String, URLMappedConfigurationItem> configurations = new HashMap<String, URLMappedConfigurationItem>();

    public WebSocketDispatcher(Endpoint endpoint) {
        this.endpoint = endpoint;
        EventManager.register((Object)this);
    }

    private void loadConfigurations() {
        this.configurations = URLMappedConfigurationLoader.loadConfigurations((Environment)LegacyPropertyFactory.getEnvironment(), (String)KEY_MAPPING_PREFIX);
    }

    @Subscribe
    public void onConfigurationChangedEvent(ConfigurationChangedEvent event) {
        for (String changed : event.getChanged()) {
            if (!changed.startsWith(KEY_MAPPING_PREFIX)) continue;
            this.loadConfigurations();
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void onRequest(ServerWebSocket webSocket) {
        ProviderServerWebSocketInvocationCreator creator;
        if (!this.initialized) {
            Object object = this.LOCK;
            synchronized (object) {
                if (!this.initialized) {
                    Transport transport = SCBEngine.getInstance().getTransportManager().findTransport("websocket");
                    this.microserviceMeta = SCBEngine.getInstance().getProducerMicroserviceMeta();
                    this.endpoint = new Endpoint(transport, this.endpoint.getEndpoint());
                    this.isEdge = TransportConfig.getRestServerVerticle().getName().equals("org.apache.servicecomb.edge.core.EdgeRestServerVerticle");
                    if (this.isEdge) {
                        this.loadConfigurations();
                    }
                }
                this.initialized = true;
            }
        }
        if (this.isEdge) {
            URLMappedConfigurationItem configurationItem = this.findConfigurationItem(webSocket.path());
            if (configurationItem == null) {
                throw new InvocationException((Response.StatusType)Response.Status.NOT_FOUND, (Object)new CommonExceptionData(String.format("path %s not found", webSocket.path())));
            }
            String path = Utils.findActualPath((String)webSocket.path(), (int)configurationItem.getPrefixSegmentCount());
            creator = new EdgeServerWebSocketInvocationCreator(configurationItem.getMicroserviceName(), path, this.endpoint, webSocket);
        } else {
            creator = new ProviderServerWebSocketInvocationCreator(this.microserviceMeta, this.endpoint, webSocket);
        }
        new WebSocketProducerInvocationFlow((InvocationCreator)creator, webSocket).run();
    }

    private URLMappedConfigurationItem findConfigurationItem(String path) {
        for (URLMappedConfigurationItem item : this.configurations.values()) {
            if (!item.getPattern().matcher(path).matches()) continue;
            return item;
        }
        return null;
    }
}

