/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.config;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.servicecomb.config.ConfigUtil;
import org.springframework.core.env.Environment;

public class BootStrapProperties {
    public static final String OLD_CONFIG_SERVICE_APPLICATION = "APPLICATION_ID";
    public static final String OLD_CONFIG_SERVICE_NAME = "service_description.name";
    public static final String OLD_CONFIG_SERVICE_VERSION = "service_description.version";
    public static final String OLD_CONFIG_SERVICE_ROLE = "service_description.role";
    public static final String OLD_CONFIG_SERVICE_ALIAS = "service_description.alias";
    public static final String OLD_CONFIG_SERVICE_DESCRIPTION = "service_description.description";
    public static final String OLD_CONFIG_SERVICE_ENVIRONMENT = "service_description.environment";
    public static final String OLD_CONFIG_SERVICE_EXTENDED_CLASS = "service_description.propertyExtendedClass";
    public static final String OLD_CONFIG_SERVICE_PROPERTIES = "service_description.properties";
    public static final String OLD_CONFIG_SERVICE_INSTANCE_PROPERTIES = "instance_description.properties";
    public static final String OLD_CONFIG_SERVICE_INSTANCE_EXTENDED_CLASS = "instance_description.propertyExtendedClass";
    public static final String OLD_CONFIG_SERVICE_INSTANCE_INITIAL_STATUS = "instance_description.initialStatus";
    public static final String CONFIG_SERVICE_APPLICATION = "servicecomb.service.application";
    public static final String CONFIG_SERVICE_NAME = "servicecomb.service.name";
    public static final String CONFIG_SERVICE_VERSION = "servicecomb.service.version";
    public static final String CONFIG_SERVICE_ROLE = "servicecomb.service.role";
    public static final String CONFIG_SERVICE_ALIAS = "servicecomb.service.alias";
    public static final String CONFIG_SERVICE_DESCRIPTION = "servicecomb.service.description";
    public static final String CONFIG_SERVICE_ENVIRONMENT = "servicecomb.service.environment";
    public static final String CONFIG_SERVICE_EXTENDED_CLASS = "servicecomb.service.propertyExtendedClass";
    public static final String CONFIG_SERVICE_PROPERTIES = "servicecomb.service.properties";
    public static final String CONFIG_SERVICE_INSTANCE_PROPERTIES = "servicecomb.instance.properties";
    public static final String CONFIG_SERVICE_INSTANCE_EXTENDED_CLASS = "servicecomb.instance.propertyExtendedClass";
    public static final String CONFIG_SERVICE_INSTANCE_INITIAL_STATUS = "servicecomb.instance.initialStatus";
    public static final String DEFAULT_APPLICATION = "default";
    public static final String DEFAULT_MICROSERVICE_NAME = "defaultMicroservice";
    public static final String DEFAULT_MICROSERVICE_VERSION = "1.0.0.0";
    public static final String DEFAULT_MICROSERVICE_ROLE = "FRONT";
    public static final String DEFAULT_MICROSERVICE_ENVIRONMENT = "";
    public static final String DEFAULT_MICROSERVICE_INSTANCE_INITIAL_STATUS = "UP";

    public static String readApplication(Environment environment) {
        return BootStrapProperties.readStringValue(environment, CONFIG_SERVICE_APPLICATION, OLD_CONFIG_SERVICE_APPLICATION, DEFAULT_APPLICATION);
    }

    public static String readServiceName(Environment environment) {
        String result = BootStrapProperties.readStringValue(environment, CONFIG_SERVICE_NAME, OLD_CONFIG_SERVICE_NAME, DEFAULT_MICROSERVICE_NAME);
        BootStrapProperties.checkMicroserviceName(result);
        return result;
    }

    public static String readServiceVersion(Environment environment) {
        return BootStrapProperties.readStringValue(environment, CONFIG_SERVICE_VERSION, OLD_CONFIG_SERVICE_VERSION, DEFAULT_MICROSERVICE_VERSION);
    }

    public static String readServiceRole(Environment environment) {
        return BootStrapProperties.readStringValue(environment, CONFIG_SERVICE_ROLE, OLD_CONFIG_SERVICE_ROLE, DEFAULT_MICROSERVICE_ROLE);
    }

    public static String readServiceAlias(Environment environment) {
        return BootStrapProperties.readStringValue(environment, CONFIG_SERVICE_ALIAS, OLD_CONFIG_SERVICE_ALIAS, null);
    }

    public static String readServiceDescription(Environment environment) {
        String[] descriptionArray = (String[])environment.getProperty(CONFIG_SERVICE_DESCRIPTION, String[].class);
        if (null == descriptionArray || descriptionArray.length < 1) {
            descriptionArray = (String[])environment.getProperty(OLD_CONFIG_SERVICE_DESCRIPTION, String[].class);
        }
        if (null == descriptionArray || descriptionArray.length < 1) {
            return null;
        }
        StringBuilder rawDescriptionBuilder = new StringBuilder();
        for (String desc : descriptionArray) {
            rawDescriptionBuilder.append(desc).append(",");
        }
        return rawDescriptionBuilder.substring(0, rawDescriptionBuilder.length() - 1);
    }

    public static String readServiceEnvironment(Environment environment) {
        return BootStrapProperties.readStringValue(environment, CONFIG_SERVICE_ENVIRONMENT, OLD_CONFIG_SERVICE_ENVIRONMENT, DEFAULT_MICROSERVICE_ENVIRONMENT);
    }

    public static String readServiceExtendedClass(Environment environment) {
        return BootStrapProperties.readStringValue(environment, CONFIG_SERVICE_EXTENDED_CLASS, OLD_CONFIG_SERVICE_EXTENDED_CLASS, null);
    }

    public static Map<String, String> readServiceProperties(Environment environment) {
        return BootStrapProperties.readProperties(environment, CONFIG_SERVICE_PROPERTIES, OLD_CONFIG_SERVICE_PROPERTIES);
    }

    public static Map<String, String> readServiceInstanceProperties(Environment environment) {
        return BootStrapProperties.readProperties(environment, CONFIG_SERVICE_INSTANCE_PROPERTIES, OLD_CONFIG_SERVICE_INSTANCE_PROPERTIES);
    }

    public static String readServiceInstanceExtendedClass(Environment environment) {
        return BootStrapProperties.readStringValue(environment, CONFIG_SERVICE_INSTANCE_EXTENDED_CLASS, OLD_CONFIG_SERVICE_INSTANCE_EXTENDED_CLASS, null);
    }

    public static String readServiceInstanceInitialStatus(Environment environment) {
        return BootStrapProperties.readStringValue(environment, CONFIG_SERVICE_INSTANCE_INITIAL_STATUS, OLD_CONFIG_SERVICE_INSTANCE_INITIAL_STATUS, DEFAULT_MICROSERVICE_INSTANCE_INITIAL_STATUS);
    }

    private static String readStringValue(Environment environment, String newKey, String oldKey, String defaultValue) {
        String result = environment.getProperty(newKey);
        if (result == null) {
            return environment.getProperty(oldKey, defaultValue);
        }
        return result;
    }

    private static Map<String, String> readProperties(Environment environment, String newKey, String oldKey) {
        String prefix = newKey;
        Set<String> keys = ConfigUtil.propertiesWithPrefix(environment, prefix);
        if (keys.isEmpty()) {
            prefix = oldKey;
            keys = ConfigUtil.propertiesWithPrefix(environment, oldKey);
        }
        HashMap<String, String> result = new HashMap<String, String>(keys.size());
        for (String key : keys) {
            result.put(key.substring(prefix.length() + 1), environment.getProperty(key));
        }
        return result;
    }

    private static void checkMicroserviceName(String name) {
        if (StringUtils.isEmpty((CharSequence)name) || name.contains("${")) {
            throw new IllegalArgumentException(String.format("MicroserviceName '%s' is invalid. you must configure '%s' or set the placeholder value.", name, CONFIG_SERVICE_NAME));
        }
    }
}

