/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.toolkit.oasv.style.validator.openapi;

import io.swagger.v3.oas.models.OpenAPI;
import java.util.Collections;
import java.util.List;
import org.apache.servicecomb.toolkit.oasv.common.OasObjectPropertyLocation;
import org.apache.servicecomb.toolkit.oasv.validation.api.OasValidationContext;
import org.apache.servicecomb.toolkit.oasv.validation.api.OasViolation;
import org.apache.servicecomb.toolkit.oasv.validation.api.OpenApiValidator;

public class OpenApiVersionGteValidator
implements OpenApiValidator {
    public static final String CONFIG_KEY = "openAPI.openapi.gte";
    public static final String ERROR = "Must be >= ";
    private final String versionGte;

    public OpenApiVersionGteValidator(String versionGte) {
        this.versionGte = versionGte;
    }

    public List<OasViolation> validate(OasValidationContext context, OasObjectPropertyLocation location, OpenAPI openAPI) {
        String[] expectedSemver;
        boolean ok;
        if (openAPI.getOpenapi() == null) {
            return Collections.singletonList(new OasViolation(location.property("openapi"), "Required"));
        }
        String[] semver = openAPI.getOpenapi().split("\\.");
        boolean bl = ok = semver[0].equals((expectedSemver = this.versionGte.split("\\."))[0]) && semver[1].equals(expectedSemver[1]) && Integer.parseInt(semver[2]) >= Integer.valueOf(expectedSemver[2]);
        if (ok) {
            return Collections.emptyList();
        }
        return Collections.singletonList(new OasViolation(location.property("openapi"), ERROR + this.versionGte));
    }
}

