/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.toolkit.oasv.style.validator.operation;

import io.swagger.v3.oas.models.Operation;
import java.util.Collections;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.servicecomb.toolkit.oasv.common.OasObjectPropertyLocation;
import org.apache.servicecomb.toolkit.oasv.common.OasObjectType;
import org.apache.servicecomb.toolkit.oasv.validation.api.OasValidationContext;
import org.apache.servicecomb.toolkit.oasv.validation.api.OasViolation;
import org.apache.servicecomb.toolkit.oasv.validation.api.OperationValidator;

public class OperationServersSizeEqValidator
implements OperationValidator {
    public static final String CONFIG_KEY = "operations.servers.size.eq";
    public static final String ERROR = "size must be == ";
    private final int expectedSize;

    public OperationServersSizeEqValidator(int expectedSize) {
        this.expectedSize = expectedSize;
    }

    public List<OasViolation> validate(OasValidationContext context, OasObjectPropertyLocation location, Operation oasObject) {
        if (CollectionUtils.size((Object)oasObject.getServers()) != this.expectedSize) {
            return Collections.singletonList(new OasViolation(location.property("servers", OasObjectType.SERVER), ERROR + this.expectedSize));
        }
        return Collections.emptyList();
    }
}

