/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.toolkit.common;

import java.io.File;
import java.net.URL;
import java.net.URLClassLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ImmediateClassLoader
extends URLClassLoader {
    private static final Logger LOGGER = LoggerFactory.getLogger(ImmediateClassLoader.class);
    private String classPath;

    public ImmediateClassLoader(URL[] urls, ClassLoader parent) {
        super(urls, parent);
        for (URL url : urls) {
            if (url == null) continue;
            File file = new File(url.getPath());
            this.classPath = file.getAbsolutePath();
            this.scanClassFile(file);
        }
    }

    private void scanClassFile(File file) {
        if (file.exists()) {
            if (file.isFile() && file.getName().endsWith(".class")) {
                try {
                    String className = file.getAbsolutePath().replace(this.classPath + File.separator, "").replace(File.separator, ".").replace(".class", "");
                    this.loadClass(className);
                }
                catch (ClassNotFoundException e) {
                    LOGGER.error(e.getMessage());
                }
            } else if (file.isDirectory()) {
                for (File f : file.listFiles()) {
                    this.scanClassFile(f);
                }
            }
        }
    }
}

