/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.toolkit.oasv.diffvalidation.api;

import java.util.List;
import java.util.function.Function;
import org.apache.servicecomb.toolkit.oasv.common.OasObjectPropertyLocation;
import org.apache.servicecomb.toolkit.oasv.common.OasObjectType;
import org.apache.servicecomb.toolkit.oasv.diffvalidation.api.OasDiffValidationContext;
import org.apache.servicecomb.toolkit.oasv.diffvalidation.api.OasDiffViolation;
import org.apache.servicecomb.toolkit.oasv.diffvalidation.api.OasObjectDiffValidator;
import org.apache.servicecomb.toolkit.oasv.diffvalidation.api.OasObjectDiffValidatorTemplate;
import org.apache.servicecomb.toolkit.oasv.diffvalidation.util.OasObjectDiffValidatorUtils;

public abstract class ListPropertyDiffValidator<T, P>
extends OasObjectDiffValidatorTemplate<T> {
    private final List<? extends OasObjectDiffValidator<P>> elementDiffValidators;
    private final Function<P, ?> elementKeyMapper;

    protected ListPropertyDiffValidator(List<? extends OasObjectDiffValidator<P>> elementDiffValidators, Function<P, Object> elementKeyMapper) {
        this.elementDiffValidators = elementDiffValidators;
        this.elementKeyMapper = elementKeyMapper;
    }

    @Override
    public List<OasDiffViolation> validateCompare(OasDiffValidationContext context, OasObjectPropertyLocation leftLocation, T leftOasObject, OasObjectPropertyLocation rightLocation, T rightOasObject) {
        return OasObjectDiffValidatorUtils.doDiffValidateListProperty(context, this.getListPropertyName(), leftLocation, this.getListProperty(leftOasObject), rightLocation, this.getListProperty(rightOasObject), this.getElementType(), this.elementKeyMapper, this.elementDiffValidators);
    }

    protected abstract List<P> getListProperty(T var1);

    protected abstract String getListPropertyName();

    protected abstract OasObjectType getElementType();
}

