/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.toolkit.oasv.diffvalidation.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import org.apache.servicecomb.toolkit.oasv.common.OasObjectPropertyLocation;
import org.apache.servicecomb.toolkit.oasv.common.OasObjectType;
import org.apache.servicecomb.toolkit.oasv.diffvalidation.api.OasDiffValidationContext;
import org.apache.servicecomb.toolkit.oasv.diffvalidation.api.OasDiffValidationException;
import org.apache.servicecomb.toolkit.oasv.diffvalidation.api.OasDiffViolation;
import org.apache.servicecomb.toolkit.oasv.diffvalidation.api.OasObjectDiffValidator;

public abstract class OasObjectDiffValidatorUtils {
    private OasObjectDiffValidatorUtils() {
    }

    public static <T> void assertNullGood(OasObjectPropertyLocation leftLocation, T leftOasObject, OasObjectPropertyLocation rightLocation, T rightOasObject) {
        OasObjectDiffValidatorUtils.assertNullConsistent(leftLocation, leftOasObject, rightLocation, rightOasObject);
        if (leftOasObject == null && rightOasObject == null) {
            throw new OasDiffValidationException("leftLocation, leftOasObject, rightLocation, rightOasObject are all null");
        }
    }

    public static <T> List<OasDiffViolation> doDiffValidateProperty(OasDiffValidationContext context, OasObjectPropertyLocation leftLocation, T leftOasObject, OasObjectPropertyLocation rightLocation, T rightOasObject, List<? extends OasObjectDiffValidator<T>> validators) {
        OasObjectDiffValidatorUtils.assertNullConsistent(leftLocation, leftOasObject, rightLocation, rightOasObject);
        if (leftLocation == null && rightLocation == null) {
            return Collections.emptyList();
        }
        ArrayList<OasDiffViolation> violations = new ArrayList<OasDiffViolation>();
        for (OasObjectDiffValidator<T> validator : validators) {
            violations.addAll(validator.validate(context, leftLocation, leftOasObject, rightLocation, rightOasObject));
        }
        return violations;
    }

    public static <T> List<OasDiffViolation> doDiffValidateListProperty(OasDiffValidationContext context, String listPropertyName, OasObjectPropertyLocation leftOwnerLocation, List<T> leftListProperty, OasObjectPropertyLocation rightOwnerLocation, List<T> rightListProperty, OasObjectType elementType, Function<T, ?> elementKeyMapper, List<? extends OasObjectDiffValidator<T>> validators) {
        int i;
        OasObjectDiffValidatorUtils.assertOwnerLocationNotNull(leftOwnerLocation, rightOwnerLocation);
        if (leftListProperty == null) {
            leftListProperty = Collections.emptyList();
        }
        if (rightListProperty == null) {
            rightListProperty = Collections.emptyList();
        }
        ArrayList<OasDiffViolation> violations = new ArrayList<OasDiffViolation>();
        for (i = 0; i < leftListProperty.size(); ++i) {
            T leftElement = leftListProperty.get(i);
            Object leftElementKey = elementKeyMapper.apply(leftElement);
            OasObjectPropertyLocation leftElementLoc = leftOwnerLocation.property(listPropertyName + "[" + i + "]", elementType);
            int rightElementIndex = OasObjectDiffValidatorUtils.indexOf(rightListProperty, leftElementKey, elementKeyMapper);
            if (rightElementIndex == -1) {
                violations.addAll(OasObjectDiffValidatorUtils.doDiffValidateProperty(context, leftElementLoc, leftElement, null, null, validators));
                continue;
            }
            T rightElement = rightListProperty.get(rightElementIndex);
            OasObjectPropertyLocation rightElementLoc = rightOwnerLocation.property(listPropertyName + "[" + rightElementIndex + "]", elementType);
            violations.addAll(OasObjectDiffValidatorUtils.doDiffValidateProperty(context, leftElementLoc, leftElement, rightElementLoc, rightElement, validators));
        }
        for (i = 0; i < rightListProperty.size(); ++i) {
            T rightElement = rightListProperty.get(i);
            Object rightElementKey = elementKeyMapper.apply(rightElement);
            OasObjectPropertyLocation rightElementLoc = rightOwnerLocation.property(listPropertyName + "[" + i + "]", elementType);
            int leftElementIndex = OasObjectDiffValidatorUtils.indexOf(leftListProperty, rightElementKey, elementKeyMapper);
            if (leftElementIndex != -1) continue;
            violations.addAll(OasObjectDiffValidatorUtils.doDiffValidateProperty(context, null, null, rightElementLoc, rightElement, validators));
        }
        return violations;
    }

    private static <T> int indexOf(List<T> elementList, Object searchKey, Function<T, ?> elementKeyMapper) {
        for (int i = 0; i < elementList.size(); ++i) {
            T element = elementList.get(i);
            if (!elementKeyMapper.apply(element).equals(searchKey)) continue;
            return i;
        }
        return -1;
    }

    public static <T> List<OasDiffViolation> doDiffValidateMapProperty(OasDiffValidationContext context, String mapPropertyName, OasObjectPropertyLocation leftOwnerLocation, Map<String, T> leftMapProperty, OasObjectPropertyLocation rightOwnerLocation, Map<String, T> rightMapProperty, OasObjectType valueType, List<? extends OasObjectDiffValidator<T>> validators) {
        String keyName;
        OasObjectDiffValidatorUtils.assertOwnerLocationNotNull(leftOwnerLocation, rightOwnerLocation);
        if (leftMapProperty == null) {
            leftMapProperty = Collections.emptyMap();
        }
        if (rightMapProperty == null) {
            rightMapProperty = Collections.emptyMap();
        }
        ArrayList<OasDiffViolation> violations = new ArrayList<OasDiffViolation>();
        for (Map.Entry<String, Object> entry : leftMapProperty.entrySet()) {
            String leftKey = entry.getKey();
            Object leftValue = entry.getValue();
            keyName = mapPropertyName + ".'" + leftKey + "'";
            OasObjectPropertyLocation leftValueLoc = leftOwnerLocation.property(keyName, valueType);
            Object rightValue = rightMapProperty.get(leftKey);
            if (rightValue == null) {
                violations.addAll(OasObjectDiffValidatorUtils.doDiffValidateProperty(context, leftValueLoc, leftValue, null, null, validators));
                continue;
            }
            OasObjectPropertyLocation rightValueLoc = rightOwnerLocation.property(keyName, valueType);
            violations.addAll(OasObjectDiffValidatorUtils.doDiffValidateProperty(context, leftValueLoc, leftValue, rightValueLoc, rightValue, validators));
        }
        for (Map.Entry<String, Object> entry : rightMapProperty.entrySet()) {
            String rightKey = entry.getKey();
            if (leftMapProperty.containsKey(rightKey)) continue;
            Object rightValue = entry.getValue();
            keyName = mapPropertyName + ".'" + rightKey + "'";
            OasObjectPropertyLocation rightLoc = rightOwnerLocation.property(keyName, valueType);
            violations.addAll(OasObjectDiffValidatorUtils.doDiffValidateProperty(context, null, null, rightLoc, rightValue, validators));
        }
        return violations;
    }

    private static void assertOwnerLocationNotNull(OasObjectPropertyLocation leftOwnerLocation, OasObjectPropertyLocation rightOwnerLocation) {
        if (leftOwnerLocation == null) {
            throw new OasDiffValidationException("leftOwnerLocation is null");
        }
        if (rightOwnerLocation == null) {
            throw new OasDiffValidationException("rightOwnerLocation is null");
        }
    }

    private static <T> void assertNullConsistent(OasObjectPropertyLocation leftLocation, T leftOasObject, OasObjectPropertyLocation rightLocation, T rightOasObject) {
        if (leftLocation == null ^ leftOasObject == null) {
            throw new OasDiffValidationException("leftLocation, leftOasObject should be both null or not");
        }
        if (rightLocation == null ^ rightOasObject == null) {
            throw new OasDiffValidationException("rightLocation, rightOasObject should be both null or not");
        }
    }
}

