/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.toolkit.oasv.validation.skeleton.schema;

import io.swagger.v3.oas.models.media.ArraySchema;
import io.swagger.v3.oas.models.media.ComposedSchema;
import io.swagger.v3.oas.models.media.Schema;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.servicecomb.toolkit.oasv.common.OasObjectPropertyLocation;
import org.apache.servicecomb.toolkit.oasv.common.OasObjectType;
import org.apache.servicecomb.toolkit.oasv.validation.api.OasValidationContext;
import org.apache.servicecomb.toolkit.oasv.validation.api.OasViolation;
import org.apache.servicecomb.toolkit.oasv.validation.api.SchemaValidator;
import org.apache.servicecomb.toolkit.oasv.validation.util.OasObjectValidatorUtils;

public abstract class SchemaRecursiveValidatorTemplate
implements SchemaValidator {
    @Override
    public final List<OasViolation> validate(OasValidationContext context, OasObjectPropertyLocation location, Schema oasObject) {
        if (StringUtils.isNotBlank((CharSequence)oasObject.get$ref())) {
            return Collections.emptyList();
        }
        if (oasObject instanceof ComposedSchema) {
            return this.validateComposedSchema(context, (ComposedSchema)oasObject, location);
        }
        if (oasObject instanceof ArraySchema) {
            return this.validateArraySchema(context, (ArraySchema)oasObject, location);
        }
        return this.validateOrdinarySchema(context, oasObject, location);
    }

    private List<OasViolation> validateOrdinarySchema(OasValidationContext context, Schema oasObject, OasObjectPropertyLocation location) {
        ArrayList<OasViolation> violations = new ArrayList<OasViolation>();
        violations.addAll(this.validateCurrentSchemaObject(context, oasObject, location));
        violations.addAll(OasObjectValidatorUtils.doValidateMapPropertyValues(context, location, "properties", oasObject.getProperties(), OasObjectType.SCHEMA, Collections.singletonList(this)));
        return violations;
    }

    private List<OasViolation> validateArraySchema(OasValidationContext context, ArraySchema oasObject, OasObjectPropertyLocation location) {
        return this.validate(context, location.property("items", OasObjectType.SCHEMA), oasObject.getItems());
    }

    private List<OasViolation> validateComposedSchema(OasValidationContext context, ComposedSchema oasObject, OasObjectPropertyLocation location) {
        ArrayList<OasViolation> violations = new ArrayList<OasViolation>();
        violations.addAll(OasObjectValidatorUtils.doValidateListProperty(context, location, "allOf", oasObject.getAllOf(), OasObjectType.SCHEMA, Collections.singletonList(this)));
        violations.addAll(OasObjectValidatorUtils.doValidateListProperty(context, location, "anyOf", oasObject.getAnyOf(), OasObjectType.SCHEMA, Collections.singletonList(this)));
        violations.addAll(OasObjectValidatorUtils.doValidateListProperty(context, location, "oneOf", oasObject.getOneOf(), OasObjectType.SCHEMA, Collections.singletonList(this)));
        return violations;
    }

    protected abstract List<OasViolation> validateCurrentSchemaObject(OasValidationContext var1, Schema var2, OasObjectPropertyLocation var3);
}

