/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.toolkit.oasv.validation.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Predicate;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;
import org.apache.servicecomb.toolkit.oasv.common.OasObjectPropertyLocation;
import org.apache.servicecomb.toolkit.oasv.common.OasObjectType;
import org.apache.servicecomb.toolkit.oasv.validation.api.OasObjectValidator;
import org.apache.servicecomb.toolkit.oasv.validation.api.OasValidationContext;
import org.apache.servicecomb.toolkit.oasv.validation.api.OasViolation;

public abstract class OasObjectValidatorUtils {
    private OasObjectValidatorUtils() {
    }

    public static <T> List<OasViolation> doValidateProperty(OasValidationContext context, OasObjectPropertyLocation propertyLoc, T propertyObject, List<? extends OasObjectValidator<T>> validators) {
        ArrayList<OasViolation> violations = new ArrayList<OasViolation>();
        for (OasObjectValidator<T> validator : validators) {
            violations.addAll(validator.validate(context, propertyLoc, propertyObject));
        }
        return violations;
    }

    public static <T> List<OasViolation> doValidateListProperty(OasValidationContext context, OasObjectPropertyLocation ownerLocation, String listPropertyName, List<T> listProperty, OasObjectType elementType, List<? extends OasObjectValidator<T>> validators) {
        if (CollectionUtils.isEmpty(listProperty)) {
            return Collections.emptyList();
        }
        ArrayList<OasViolation> violations = new ArrayList<OasViolation>();
        for (int i = 0; i < listProperty.size(); ++i) {
            T object = listProperty.get(i);
            String elementName = listPropertyName + "[" + i + "]";
            OasObjectPropertyLocation elementLoc = ownerLocation.property(elementName, elementType);
            violations.addAll(OasObjectValidatorUtils.doValidateProperty(context, elementLoc, object, validators));
        }
        return violations;
    }

    public static <T> List<OasViolation> doValidateMapPropertyKeys(OasObjectPropertyLocation ownerLocation, String mapPropertyName, Map<String, T> mapProperty, Predicate<String> keyPredicate, Function<String, String> errorMessage) {
        if (MapUtils.isEmpty(mapProperty)) {
            return Collections.emptyList();
        }
        ArrayList<OasViolation> violations = new ArrayList<OasViolation>();
        for (Map.Entry<String, T> entry : mapProperty.entrySet()) {
            String key = entry.getKey();
            String keyName = mapPropertyName + ".'" + key + "'";
            OasObjectPropertyLocation keyLoc = ownerLocation.property(keyName);
            if (keyPredicate.test(key)) continue;
            violations.add(new OasViolation(keyLoc, errorMessage.apply(key)));
        }
        return violations;
    }

    public static <T> List<OasViolation> doValidateMapPropertyValues(OasValidationContext context, OasObjectPropertyLocation ownerLocation, String mapPropertyName, Map<String, T> mapProperty, OasObjectType valueType, List<? extends OasObjectValidator<T>> validators) {
        if (MapUtils.isEmpty(mapProperty)) {
            return Collections.emptyList();
        }
        ArrayList<OasViolation> violations = new ArrayList<OasViolation>();
        for (Map.Entry<String, T> entry : mapProperty.entrySet()) {
            String key = entry.getKey();
            T value = entry.getValue();
            String keyName = mapPropertyName + ".'" + key + "'";
            OasObjectPropertyLocation valueLoc = ownerLocation.property(keyName, valueType);
            violations.addAll(OasObjectValidatorUtils.doValidateProperty(context, valueLoc, value, validators));
        }
        return violations;
    }
}

