/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.common.rest.codec;

import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.core.Response;
import org.apache.servicecomb.common.rest.codec.RestClientRequest;
import org.apache.servicecomb.common.rest.definition.RestOperationMeta;
import org.apache.servicecomb.common.rest.definition.RestParam;
import org.apache.servicecomb.swagger.invocation.exception.InvocationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class RestCodec {
    private static final Logger LOG = LoggerFactory.getLogger(RestCodec.class);

    private RestCodec() {
    }

    public static void argsToRest(Object[] args, RestOperationMeta restOperation, RestClientRequest clientRequest) throws Exception {
        int paramSize = restOperation.getParamList().size();
        if (paramSize == 0) {
            return;
        }
        if (paramSize != args.length) {
            throw new Exception("wrong number of arguments");
        }
        for (int idx = 0; idx < paramSize; ++idx) {
            RestParam param = restOperation.getParamList().get(idx);
            param.getParamProcessor().setValue(clientRequest, args[idx]);
        }
    }

    public static Object[] restToArgs(HttpServletRequest request, RestOperationMeta restOperation) throws InvocationException {
        List<RestParam> paramList = restOperation.getParamList();
        Object[] paramValues = new Object[paramList.size()];
        for (int idx = 0; idx < paramList.size(); ++idx) {
            RestParam param = paramList.get(idx);
            try {
                paramValues[idx] = param.getParamProcessor().getValue(request);
                continue;
            }
            catch (Exception e) {
                throw new InvocationException((Response.StatusType)Response.Status.BAD_REQUEST, String.format("Parameter is not valid for operation [%s]. Parameter is [%s]. Processor is [%s].", restOperation.getOperationMeta().getMicroserviceQualifiedName(), param.getParamName(), param.getParamProcessor().getProcessorType()));
            }
        }
        return paramValues;
    }
}

