/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.common.rest.filter;

import java.util.List;
import java.util.concurrent.CompletableFuture;
import org.apache.servicecomb.common.rest.filter.HttpServerFilter;
import org.apache.servicecomb.core.Invocation;
import org.apache.servicecomb.foundation.vertx.http.HttpServletResponseEx;

public class HttpServerFilterBeforeSendResponseExecutor {
    private List<HttpServerFilter> httpServerFilters;
    private Invocation invocation;
    private HttpServletResponseEx responseEx;
    private int currentIndex;
    private CompletableFuture<Void> future = new CompletableFuture();

    public HttpServerFilterBeforeSendResponseExecutor(List<HttpServerFilter> httpServerFilters, Invocation invocation, HttpServletResponseEx responseEx) {
        this.httpServerFilters = httpServerFilters;
        this.invocation = invocation;
        this.responseEx = responseEx;
    }

    public CompletableFuture<Void> run() {
        this.doRun();
        return this.future;
    }

    protected CompletableFuture<Void> safeInvoke(HttpServerFilter httpServerFilter) {
        try {
            if (httpServerFilter.enabled()) {
                return httpServerFilter.beforeSendResponseAsync(this.invocation, this.responseEx);
            }
            CompletableFuture<Void> eFuture = new CompletableFuture<Void>();
            eFuture.complete(null);
            return eFuture;
        }
        catch (Throwable e) {
            CompletableFuture<Void> eFuture = new CompletableFuture<Void>();
            eFuture.completeExceptionally(e);
            return eFuture;
        }
    }

    protected void doRun() {
        if (this.currentIndex == this.httpServerFilters.size()) {
            this.future.complete(null);
            return;
        }
        HttpServerFilter httpServerFilter = this.httpServerFilters.get(this.currentIndex);
        ++this.currentIndex;
        CompletableFuture<Void> stepFuture = this.safeInvoke(httpServerFilter);
        stepFuture.whenComplete((v, e) -> {
            if (e == null) {
                this.doRun();
                return;
            }
            this.future.completeExceptionally((Throwable)e);
        });
    }
}

