/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.toolkit.oasv.compatibility.validators.schema.request;

import io.swagger.v3.oas.models.media.Schema;
import java.math.BigDecimal;
import org.apache.servicecomb.toolkit.oasv.compatibility.validators.schema.SchemaPropertyChangeValidator;
import org.apache.servicecomb.toolkit.oasv.diffvalidation.api.OasDiffValidationContext;
import org.apache.servicecomb.toolkit.oasv.diffvalidation.util.OasDiffValidationContextUtils;

public class SchemaMultipleOfChangeInRequestValidator
extends SchemaPropertyChangeValidator<BigDecimal> {
    public static final String VIOLATION_MESSAGE = "right value is neither equal to left value nor a factor of left value";

    @Override
    protected BigDecimal getProperty(Schema schema) {
        return schema.getMultipleOf();
    }

    @Override
    protected String getPropertyName() {
        return "multipleOf";
    }

    @Override
    protected String getMessage(BigDecimal leftProperty, BigDecimal rightProperty) {
        return VIOLATION_MESSAGE;
    }

    @Override
    protected boolean isAllowed(BigDecimal leftProperty, BigDecimal rightProperty) {
        return BigDecimal.ZERO.compareTo(leftProperty.divideAndRemainder(rightProperty)[1]) == 0;
    }

    @Override
    protected boolean needValidate(OasDiffValidationContext context) {
        return OasDiffValidationContextUtils.isInParameter((OasDiffValidationContext)context) || OasDiffValidationContextUtils.isInRequestBody((OasDiffValidationContext)context);
    }
}

