/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.storage.aggregate;

import java.math.BigInteger;
import java.util.Arrays;
import org.apache.sis.util.internal.shared.Strings;

final class DimensionSelector
implements Comparable<DimensionSelector> {
    final int dimension;
    private final long[] positions;
    private long maxSize;
    private BigInteger sumOfSize;
    boolean isMosaic;
    boolean isConstantPosition;
    private double relativeIncrement;
    private long incrementRange;

    DimensionSelector(int dimension, int sliceCount) {
        this.dimension = dimension;
        this.positions = new long[sliceCount];
        this.sumOfSize = BigInteger.ZERO;
    }

    final void setSliceExtent(int sliceIndex, long position, long extentSize) {
        this.positions[sliceIndex] = position;
        this.maxSize = Math.max(this.maxSize, extentSize);
        this.sumOfSize = this.sumOfSize.add(BigInteger.valueOf(extentSize));
    }

    final void finish() {
        Arrays.sort(this.positions);
        long maxInc = 0L;
        long minInc = Long.MAX_VALUE;
        BigInteger sumOfInc = BigInteger.ZERO;
        long previous = this.positions[0];
        for (int i = 1; i < this.positions.length; ++i) {
            long p = this.positions[i];
            long d = p - previous;
            if (d == 0L) continue;
            if (d < minInc) {
                minInc = d;
            }
            if (d > maxInc) {
                maxInc = d;
            }
            sumOfInc = sumOfInc.add(BigInteger.valueOf(d));
            previous = p;
        }
        this.isConstantPosition = maxInc == 0L;
        this.isMosaic = this.isConstantPosition;
        if (minInc <= maxInc) {
            this.relativeIncrement = sumOfInc.doubleValue() / this.sumOfSize.doubleValue();
            this.incrementRange = maxInc - minInc;
            boolean bl = this.isMosaic = this.incrementRange == 0L && (this.isConstantPosition || maxInc == this.maxSize);
        }
        if (this.isMosaic) {
            this.isMosaic = this.sumOfSize.equals(BigInteger.valueOf(this.maxSize).multiply(BigInteger.valueOf(this.positions.length)));
        }
    }

    @Override
    public int compareTo(DimensionSelector other) {
        int c = Boolean.compare(other.isConstantPosition, this.isConstantPosition);
        if (c == 0 && (c = Double.compare(this.relativeIncrement, other.relativeIncrement)) == 0) {
            c = Long.compare(other.incrementRange, this.incrementRange);
        }
        return c;
    }

    public String toString() {
        return Strings.toString(this.getClass(), (Object[])new Object[]{"dimension", this.dimension, "isMosaic", this.isMosaic, "isConstantPosition", this.isConstantPosition, "relativeIncrement", this.relativeIncrement, "incrementRange", this.incrementRange});
    }
}

