/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.referencing.internal;

import java.awt.geom.AffineTransform;
import java.util.Objects;
import org.apache.sis.referencing.internal.shared.AffineTransform2D;
import org.apache.sis.system.Semaphores;
import org.opengis.parameter.ParameterDescriptorGroup;
import org.opengis.parameter.ParameterValueGroup;
import org.opengis.referencing.operation.MathTransform;

public final class ParameterizedAffine
extends AffineTransform2D {
    private static final long serialVersionUID = 906346920928432466L;
    private final ParameterValueGroup parameters;
    private final boolean isDefinitive;

    public ParameterizedAffine(AffineTransform transform, ParameterValueGroup parameters, boolean isDefinitive) {
        super(transform);
        this.parameters = parameters;
        this.isDefinitive = isDefinitive;
    }

    public MathTransform newTransform(MathTransform transform) {
        if (transform instanceof AffineTransform) {
            return new ParameterizedAffine((AffineTransform)transform, this.parameters, false);
        }
        return transform;
    }

    private boolean showParameters() {
        return this.isDefinitive || Semaphores.TRANSFORM_ENCLOSED_IN_OPERATION.get();
    }

    @Override
    public ParameterDescriptorGroup getParameterDescriptors() {
        return this.showParameters() ? this.parameters.getDescriptor() : super.getParameterDescriptors();
    }

    @Override
    public ParameterValueGroup getParameterValues() {
        return this.showParameters() ? this.parameters : super.getParameterValues();
    }

    @Override
    public boolean equals(Object object) {
        if (super.equals(object)) {
            if (object instanceof ParameterizedAffine) {
                ParameterizedAffine that = (ParameterizedAffine)object;
                return this.isDefinitive == that.isDefinitive && Objects.equals(this.parameters, that.parameters);
            }
            return true;
        }
        return false;
    }
}

