/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.console;

import org.apache.sis.console.FormattedOutputCommand;
import org.apache.sis.console.InvalidOptionException;
import org.apache.sis.console.MetadataCommand;
import org.apache.sis.console.OutputFormat;
import org.opengis.metadata.Metadata;
import org.opengis.referencing.ReferenceSystem;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

final class CRSCommand
extends FormattedOutputCommand {
    CRSCommand(int commandIndex, Object[] args) throws InvalidOptionException {
        super(commandIndex, args, MetadataCommand.options(), OutputFormat.WKT, OutputFormat.XML);
    }

    @Override
    public int run() throws Exception {
        Object metadata = this.readMetadataOrCRS();
        if (this.hasUnexpectedFileCount) {
            return 3;
        }
        if (metadata != null) {
            if (metadata instanceof CoordinateReferenceSystem) {
                this.format(metadata);
            } else {
                for (ReferenceSystem rs : ((Metadata)metadata).getReferenceSystemInfo()) {
                    if (!(rs instanceof CoordinateReferenceSystem)) continue;
                    this.format(rs);
                    break;
                }
            }
        }
        return 0;
    }
}

