/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.extensions.mdc.internal;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Dictionary;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Modified;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.commons.osgi.PropertiesUtil;
import org.apache.sling.extensions.mdc.internal.SlingMDCFilter;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceFactory;
import org.osgi.framework.ServiceRegistration;
import org.slf4j.MDC;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Service
@Component(metatype=true, label="%mdc.label", description="%mdc.description")
@Property(name="pattern", value={"/.*"}, propertyPrivate=true)
public class MDCInsertingFilter
implements Filter {
    public static final String REQUEST_REMOTE_HOST_MDC_KEY = "req.remoteHost";
    public static final String REQUEST_USER_AGENT_MDC_KEY = "req.userAgent";
    public static final String REQUEST_REQUEST_URI = "req.requestURI";
    public static final String REQUEST_QUERY_STRING = "req.queryString";
    public static final String REQUEST_REQUEST_URL = "req.requestURL";
    public static final String REQUEST_X_FORWARDED_FOR = "req.xForwardedFor";
    private static final String[] DEFAULT_KEY_NAMES = new String[]{"req.remoteHost", "req.userAgent", "req.requestURI", "req.queryString", "req.requestURL", "req.xForwardedFor"};
    private static final String[] EMPTY_VALUE = new String[0];
    @Property
    private static final String PROP_HEADERS = "headers";
    @Property
    private static final String PROP_PARAMS = "parameters";
    @Property
    private static final String PROP_COOKIES = "cookies";
    private Set<String> keyNames = new CopyOnWriteArraySet<String>();
    private Set<String> headerNames = new CopyOnWriteArraySet<String>();
    private Set<String> parameterNames = new CopyOnWriteArraySet<String>();
    private Set<String> cookieNames = new CopyOnWriteArraySet<String>();
    private ServiceRegistration filterReg;

    public void init(FilterConfig filterConfig) throws ServletException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        this.insertIntoMDC(request);
        try {
            chain.doFilter(request, response);
        }
        finally {
            this.clearMDC();
        }
    }

    public void destroy() {
    }

    private void insertIntoMDC(ServletRequest request) {
        this.nullSafePut(REQUEST_REMOTE_HOST_MDC_KEY, request.getRemoteHost());
        if (request instanceof HttpServletRequest) {
            HttpServletRequest httpRequest = (HttpServletRequest)request;
            this.nullSafePut(REQUEST_REQUEST_URI, httpRequest.getRequestURI());
            StringBuffer requestURL = httpRequest.getRequestURL();
            if (requestURL != null) {
                this.nullSafePut(REQUEST_REQUEST_URL, requestURL.toString());
            }
            this.nullSafePut(REQUEST_QUERY_STRING, httpRequest.getQueryString());
            this.nullSafePut(REQUEST_USER_AGENT_MDC_KEY, httpRequest.getHeader("User-Agent"));
            this.nullSafePut(REQUEST_X_FORWARDED_FOR, httpRequest.getHeader("X-Forwarded-For"));
            for (String paramName : this.parameterNames) {
                this.nullSafePut(paramName, httpRequest.getParameter(paramName));
            }
            for (String headerName : this.headerNames) {
                this.nullSafePut(headerName, httpRequest.getHeader(headerName));
            }
            Cookie[] cookies = httpRequest.getCookies();
            if (cookies != null) {
                for (Cookie c : cookies) {
                    if (!this.cookieNames.contains(c.getName())) continue;
                    this.nullSafePut(c.getName(), c.getValue());
                }
            }
        }
    }

    private void clearMDC() {
        for (String key : this.keyNames) {
            MDC.remove((String)key);
        }
    }

    @Activate
    private void activate(BundleContext context, Map<String, Object> config) {
        Properties p = new Properties();
        p.setProperty("filter.scope", "REQUEST");
        this.filterReg = context.registerService(Filter.class.getName(), (Object)new ServiceFactory(){
            private Object instance;

            public synchronized Object getService(Bundle bundle, ServiceRegistration serviceRegistration) {
                if (this.instance == null) {
                    this.instance = new SlingMDCFilter();
                }
                return this.instance;
            }

            public void ungetService(Bundle bundle, ServiceRegistration serviceRegistration, Object o) {
            }
        }, (Dictionary)p);
        this.modified(config);
    }

    @Modified
    private void modified(Map<String, Object> config) {
        Set<String> headers = MDCInsertingFilter.toTrimmedValues(config, PROP_HEADERS);
        this.headerNames.clear();
        this.headerNames.addAll(headers);
        Set<String> cookies = MDCInsertingFilter.toTrimmedValues(config, PROP_COOKIES);
        this.cookieNames.clear();
        this.cookieNames.addAll(cookies);
        Set<String> params = MDCInsertingFilter.toTrimmedValues(config, PROP_PARAMS);
        this.parameterNames.clear();
        this.parameterNames.addAll(params);
        ArrayList<String> keyNames = new ArrayList<String>();
        keyNames.addAll(this.headerNames);
        keyNames.addAll(this.cookieNames);
        keyNames.addAll(this.parameterNames);
        keyNames.addAll(Arrays.asList(DEFAULT_KEY_NAMES));
        this.keyNames.clear();
        this.keyNames.addAll(keyNames);
    }

    @Deactivate
    private void deactivate() {
        if (this.filterReg != null) {
            this.filterReg.unregister();
        }
    }

    private void nullSafePut(String key, String value) {
        if (key != null && value != null) {
            MDC.put((String)key, (String)value);
        }
    }

    private static Set<String> toTrimmedValues(Map<String, Object> config, String propName) {
        String[] values = PropertiesUtil.toStringArray(config.get(propName), EMPTY_VALUE);
        HashSet<String> result = new HashSet<String>(values.length);
        for (String value : values) {
            if (value == null || value.trim().length() <= 0) continue;
            result.add(value.trim());
        }
        return result;
    }
}

