/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.jcr.davex.impl.servlets;

import java.io.IOException;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.sling.auth.core.AuthenticationSupport;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.propertytypes.ServiceDescription;
import org.osgi.service.component.propertytypes.ServiceRanking;
import org.osgi.service.component.propertytypes.ServiceVendor;
import org.osgi.service.http.context.ServletContextHelper;
import org.osgi.service.http.whiteboard.propertytypes.HttpWhiteboardContext;

@Component(service={ServletContextHelper.class})
@HttpWhiteboardContext(name="DavExAuthHttpContext", path="/")
@ServiceDescription(value="Sling JcrRemoting Servlet")
@ServiceVendor(value="The Apache Software Foundation")
@ServiceRanking(value=5)
public class AuthHttpContext
extends ServletContextHelper {
    static final String HTTP_CONTEXT_NAME = "DavExAuthHttpContext";
    @Reference
    private AuthenticationSupport authenticator;

    public Set<String> getResourcePaths(String path) {
        return null;
    }

    public boolean handleSecurity(HttpServletRequest request, HttpServletResponse response) throws IOException {
        AuthenticationSupport localAuthenticator = this.authenticator;
        if (localAuthenticator != null) {
            String wsp = this.getWorkspace(request.getPathInfo());
            if (wsp != null) {
                request.setAttribute("j_workspace", (Object)wsp);
            }
            return localAuthenticator.handleSecurity(request, response);
        }
        response.sendError(503);
        response.flushBuffer();
        return false;
    }

    private final String getWorkspace(String uriPath) {
        if (uriPath != null && uriPath.length() > 1 && uriPath.charAt(0) == '/') {
            int end = uriPath.indexOf(47, 1);
            if (end > 1) {
                return uriPath.substring(1, end);
            }
            if (end < 0) {
                return uriPath.substring(1);
            }
        }
        return null;
    }
}

