/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.jcr.jackrabbit.server.impl.security;

import java.security.Principal;
import javax.jcr.Credentials;
import javax.jcr.RepositoryException;
import org.apache.jackrabbit.core.security.authentication.Authentication;
import org.apache.sling.jcr.jackrabbit.server.impl.security.AdministrativeCredentials;
import org.apache.sling.jcr.jackrabbit.server.impl.security.AnonCredentials;

public abstract class TrustedCredentials
implements Credentials {
    private static final long serialVersionUID = 5153578149776402602L;
    private Principal principal;
    private Authentication authentication;

    public TrustedCredentials(String userId) {
        this.principal = this.getPrincipal(userId);
        this.authentication = new Authentication(){

            @Override
            public boolean canHandle(Credentials credentials) {
                return credentials instanceof AdministrativeCredentials || credentials instanceof AnonCredentials;
            }

            @Override
            public boolean authenticate(Credentials credentials) throws RepositoryException {
                return credentials instanceof AdministrativeCredentials || credentials instanceof AnonCredentials;
            }
        };
    }

    protected abstract Principal getPrincipal(String var1);

    public Principal getPrincipal() {
        return this.principal;
    }

    public Authentication getTrustedAuthentication() {
        return this.authentication;
    }

    public Object getImpersonator() {
        return null;
    }
}

