/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.testing.teleporter.client;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.net.HttpURLConnection;

class MultipartAdapter {
    final OutputStream out;
    final PrintWriter pw;
    final String boundary = "______________" + Double.toHexString(Math.random()) + "______________";
    final String eol = "\r\n";
    final String dashes = "--";
    final String charset;
    int counter = 0;

    MultipartAdapter(HttpURLConnection c, String charset) throws IOException {
        this.charset = charset;
        c.setUseCaches(false);
        c.setDoOutput(true);
        c.setInstanceFollowRedirects(false);
        c.setRequestProperty("Content-Type", "multipart/form-data; boundary=" + this.boundary);
        this.out = c.getOutputStream();
        this.pw = new PrintWriter((Writer)new OutputStreamWriter(this.out, charset), true);
    }

    void close() throws IOException {
        this.pw.append("--").append(this.boundary).append("--").append("\r\n").flush();
        this.out.close();
    }

    MultipartAdapter parameter(String name, String value) {
        this.pw.append("--").append(this.boundary).append("\r\n");
        this.pw.append("Content-Disposition: form-data; name=\"" + name + "\"").append("\r\n");
        this.pw.append("Content-Type: text/plain; charset=").append(this.charset).append("\r\n");
        this.pw.append("\r\n").append(value).append("\r\n").flush();
        return this;
    }

    MultipartAdapter file(String fieldName, String filename, String contentType, InputStream data) throws IOException {
        this.pw.append("--").append(this.boundary).append("\r\n");
        this.pw.append("Content-Disposition: form-data; name=\"").append(fieldName).append("\"");
        this.pw.append("; filename=\"").append(filename).append("\"").append("\r\n");
        this.pw.append("Content-Type: ").append(contentType).append("\r\n");
        this.pw.append("Content-Transfer-Encoding: binary").append("\r\n");
        this.pw.append("\r\n").flush();
        this.copy(data, this.out);
        this.pw.append("\r\n").flush();
        return this;
    }

    private void copy(InputStream is, OutputStream os) throws IOException {
        byte[] buffer = new byte[16384];
        int n = 0;
        while ((n = is.read(buffer, 0, buffer.length)) > 0) {
            os.write(buffer, 0, n);
        }
        os.flush();
    }
}

