/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.models.caconfig.impl.injectors;

import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Array;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ValueMap;
import org.apache.sling.caconfig.ConfigurationBuilder;
import org.apache.sling.caconfig.ConfigurationResolveException;
import org.apache.sling.caconfig.ConfigurationResolver;
import org.apache.sling.caconfig.annotation.Configuration;
import org.apache.sling.caconfig.management.multiplexer.ConfigurationInjectResourceDetectionStrategyMultiplexer;
import org.apache.sling.models.caconfig.annotations.ContextAwareConfiguration;
import org.apache.sling.models.caconfig.impl.injectors.ContextAwareConfigurationProcessor;
import org.apache.sling.models.spi.AcceptsNullName;
import org.apache.sling.models.spi.DisposalCallbackRegistry;
import org.apache.sling.models.spi.Injector;
import org.apache.sling.models.spi.injectorspecific.InjectAnnotationProcessor2;
import org.apache.sling.models.spi.injectorspecific.StaticInjectAnnotationProcessorFactory;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.propertytypes.ServiceRanking;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(service={Injector.class, StaticInjectAnnotationProcessorFactory.class, AcceptsNullName.class})
@ServiceRanking(value=6000)
public class ContextAwareConfigurationInjector
implements Injector,
StaticInjectAnnotationProcessorFactory,
AcceptsNullName {
    private static final Logger log = LoggerFactory.getLogger(ContextAwareConfigurationInjector.class);
    @Reference
    private ConfigurationResolver configurationResolver;
    @Reference
    private ConfigurationInjectResourceDetectionStrategyMultiplexer configurationInjectResourceDetectionStrategyMultiplexer;

    @NotNull
    public String getName() {
        return "caconfig";
    }

    public InjectAnnotationProcessor2 createAnnotationProcessor(AnnotatedElement element) {
        ContextAwareConfiguration annotation = this.getAnnotation(element);
        if (annotation != null) {
            return new ContextAwareConfigurationProcessor(annotation);
        }
        return null;
    }

    public Object getValue(@NotNull Object adaptable, String name, @NotNull Type declaredType, @NotNull AnnotatedElement element, @NotNull DisposalCallbackRegistry callbackRegistry) {
        ContextAwareConfiguration annotation = this.getAnnotation(element);
        if (annotation == null) {
            log.debug("Injection only supported using @ContextAwareConfiguration annotation.");
            return null;
        }
        Resource resource = this.getResource(adaptable);
        if (resource == null) {
            log.warn("Unable to get resource from {}", adaptable);
            return null;
        }
        ConfigurationBuilder configurationBuilder = this.configurationResolver.get(resource);
        if (StringUtils.isNotBlank((CharSequence)annotation.name())) {
            configurationBuilder = configurationBuilder.name(annotation.name());
        }
        if (declaredType instanceof Class) {
            Class clazz = (Class)declaredType;
            if (clazz.isArray()) {
                Collection<?> result = this.getConfigurationCollection(configurationBuilder, clazz.getComponentType());
                Object array = Array.newInstance(clazz.getComponentType(), result.size());
                Iterator<?> resultIterator = result.iterator();
                int i = 0;
                while (resultIterator.hasNext()) {
                    Array.set(array, i++, resultIterator.next());
                }
                return array;
            }
            return this.getConfiguration(configurationBuilder, clazz);
        }
        if (declaredType instanceof ParameterizedType) {
            ParameterizedType parameterizedType = (ParameterizedType)declaredType;
            if (parameterizedType.getActualTypeArguments().length != 1) {
                return null;
            }
            Class collectionType = (Class)parameterizedType.getRawType();
            if (!collectionType.equals(Collection.class) && !collectionType.equals(List.class)) {
                return null;
            }
            Class clazz = (Class)parameterizedType.getActualTypeArguments()[0];
            Collection<?> result = this.getConfigurationCollection(configurationBuilder, clazz);
            if (collectionType.equals(List.class)) {
                return new ArrayList(result);
            }
            return result;
        }
        log.warn("Cannot handle type {}", (Object)declaredType);
        return null;
    }

    @Nullable
    private ContextAwareConfiguration getAnnotation(AnnotatedElement element) {
        return element.getAnnotation(ContextAwareConfiguration.class);
    }

    @Nullable
    private Resource getResource(@NotNull Object adaptable) {
        if (adaptable instanceof Resource) {
            return (Resource)adaptable;
        }
        if (adaptable instanceof SlingHttpServletRequest) {
            SlingHttpServletRequest request = (SlingHttpServletRequest)adaptable;
            Resource resource = this.configurationInjectResourceDetectionStrategyMultiplexer.detectResource(request);
            if (resource == null) {
                resource = request.getResource();
            }
            return resource;
        }
        return null;
    }

    @Nullable
    private Object getConfiguration(@NotNull ConfigurationBuilder configurationBuilder, @NotNull Class<?> clazz) {
        try {
            if (clazz.equals(ValueMap.class)) {
                return configurationBuilder.asValueMap();
            }
            if (this.isContextAwareConfigAnnotationClass(clazz)) {
                return configurationBuilder.as(clazz);
            }
            return configurationBuilder.asAdaptable(clazz);
        }
        catch (ConfigurationResolveException ex) {
            throw new ConfigurationResolveException("Class " + clazz.getName() + ": " + ex.getMessage(), (Throwable)ex);
        }
    }

    @NotNull
    private Collection<?> getConfigurationCollection(@NotNull ConfigurationBuilder configurationBuilder, @NotNull Class<?> clazz) {
        try {
            if (clazz.equals(ValueMap.class)) {
                return configurationBuilder.asValueMapCollection();
            }
            if (this.isContextAwareConfigAnnotationClass(clazz)) {
                return configurationBuilder.asCollection(clazz);
            }
            return configurationBuilder.asAdaptableCollection(clazz);
        }
        catch (ConfigurationResolveException ex) {
            throw new ConfigurationResolveException("Class " + clazz.getName() + ": " + ex.getMessage(), (Throwable)ex);
        }
    }

    private boolean isContextAwareConfigAnnotationClass(Class<?> clazz) {
        return clazz.isAnnotation() && clazz.isAnnotationPresent(Configuration.class);
    }
}

