/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.query.impl.resource;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.query.impl.resource.ResourcePropertyPredicate;
import org.apache.sling.query.impl.resource.jcr.JcrTypeResolver;
import org.apache.sling.query.impl.selector.parser.Attribute;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResourcePredicate
implements Predicate<Resource> {
    private static final Logger LOG = LoggerFactory.getLogger(ResourcePredicate.class);
    private final String resourceType;
    private final String resourceName;
    private final List<Predicate<Resource>> subPredicates;
    private JcrTypeResolver typeResolver;

    public ResourcePredicate(String resourceType, String resourceName, List<Attribute> attributes, JcrTypeResolver typeResolver) {
        this.resourceType = resourceType;
        this.resourceName = resourceName;
        this.subPredicates = new ArrayList<Predicate<Resource>>();
        for (Attribute a : attributes) {
            this.subPredicates.add(new ResourcePropertyPredicate(a));
        }
        this.typeResolver = typeResolver;
    }

    @Override
    public boolean test(Resource resource) {
        if (StringUtils.isNotBlank((CharSequence)this.resourceName) && !resource.getName().equals(this.resourceName)) {
            return false;
        }
        if (!this.isResourceType(resource, this.resourceType)) {
            return false;
        }
        for (Predicate<Resource> predicate : this.subPredicates) {
            if (predicate.test(resource)) continue;
            return false;
        }
        return true;
    }

    private boolean isResourceType(Resource resource, String resourceType) {
        if (StringUtils.isBlank((CharSequence)resourceType)) {
            return true;
        }
        if (resource.isResourceType(resourceType)) {
            return true;
        }
        if (!this.isValidType(resourceType)) {
            return false;
        }
        Node node = (Node)resource.adaptTo(Node.class);
        try {
            if (node != null) {
                return node.isNodeType(resourceType);
            }
        }
        catch (RepositoryException e) {
            LOG.error("Can't check node type", (Throwable)e);
        }
        return false;
    }

    private boolean isValidType(String type) {
        return this.typeResolver.isJcrType(type);
    }
}

