/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.query.impl.resource.jcr;

import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.nodetype.NoSuchNodeTypeException;
import javax.jcr.nodetype.NodeTypeManager;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.query.impl.resource.jcr.JcrTypeResolver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SessionJcrTypeResolver
implements JcrTypeResolver {
    private static final Logger LOG = LoggerFactory.getLogger(SessionJcrTypeResolver.class);
    private final NodeTypeManager nodeTypeManager;

    public SessionJcrTypeResolver(ResourceResolver resolver) {
        NodeTypeManager m = null;
        try {
            if (resolver != null) {
                m = ((Session)resolver.adaptTo(Session.class)).getWorkspace().getNodeTypeManager();
            }
        }
        catch (RepositoryException e) {
            LOG.error("Can't get node type manager", (Throwable)e);
            m = null;
        }
        this.nodeTypeManager = m;
    }

    @Override
    public boolean isJcrType(String name) {
        if (this.nodeTypeManager == null) {
            return false;
        }
        if (name == null || name.contains("/")) {
            return false;
        }
        try {
            this.nodeTypeManager.getNodeType(name);
            return true;
        }
        catch (NoSuchNodeTypeException e) {
            return false;
        }
        catch (RepositoryException e) {
            LOG.error("Can't check node type " + name, (Throwable)e);
            return false;
        }
    }

    @Override
    public boolean isSubtype(String supertype, String subtype) {
        if (this.nodeTypeManager == null) {
            return false;
        }
        if (!this.isJcrType(subtype) || !this.isJcrType(supertype)) {
            return false;
        }
        try {
            return this.nodeTypeManager.getNodeType(subtype).isNodeType(supertype);
        }
        catch (RepositoryException e) {
            LOG.error("Can't compare two node types: " + subtype + " and " + supertype, (Throwable)e);
            return false;
        }
    }
}

