/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.sample.slingshot.ratings.impl;

import java.io.IOException;
import java.io.PrintWriter;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ResourceResolverFactory;
import org.apache.sling.api.servlets.SlingAllMethodsServlet;
import org.apache.sling.sample.slingshot.ratings.RatingsService;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(service={Servlet.class}, property={"sling.servlet.methods=POST", "sling.servlet.extensions=ratings", "sling.servlet.resourceTypes=slingshot/Streamentry"})
public class RatingPostServlet
extends SlingAllMethodsServlet {
    private static final long serialVersionUID = 1L;
    private final Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    @Reference
    private ResourceResolverFactory factory;
    @Reference
    private RatingsService ratingsService;

    protected void doPost(SlingHttpServletRequest request, SlingHttpServletResponse response) throws ServletException, IOException {
        String rating = request.getParameter("rating");
        String userId = request.getRemoteUser();
        this.logger.debug("New rating from {} : {}", (Object)userId, (Object)rating);
        try (ResourceResolver resolver = null;){
            resolver = this.factory.getServiceResourceResolver(null);
            Resource reqResource = resolver.getResource(request.getResource().getPath());
            this.ratingsService.setRating(reqResource, userId, Double.valueOf(rating));
        }
        response.setContentType("application/json");
        response.setCharacterEncoding("utf-8");
        response.setStatus(200);
        PrintWriter pw = response.getWriter();
        pw.print("{ ");
        pw.print(" \"rating\" : ");
        pw.print(String.valueOf(this.ratingsService.getRating(request.getResource())));
        pw.print("}");
    }
}

