/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.maven.slingstart;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import java.util.jar.Manifest;
import org.apache.commons.io.IOUtils;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;
import org.apache.sling.maven.slingstart.AbstractSlingStartMojo;
import org.apache.sling.maven.slingstart.JarArchiverHelper;
import org.codehaus.plexus.archiver.Archiver;
import org.codehaus.plexus.archiver.jar.JarArchiver;

@Mojo(name="package", defaultPhase=LifecyclePhase.PRE_INTEGRATION_TEST, requiresDependencyResolution=ResolutionScope.TEST, threadSafe=true)
public class PackageMojo
extends AbstractSlingStartMojo {
    private static final String[] EXCLUDES_MANIFEST = new String[]{"META-INF/MANIFEST.MF"};
    @Parameter(defaultValue="false")
    protected boolean createWebapp;
    @Parameter(defaultValue="true")
    protected boolean attachArtifact;
    @Component(role=Archiver.class, hint="jar")
    private JarArchiver jarArchiver;

    public void execute() throws MojoExecutionException, MojoFailureException {
        Map globalContentsMap = (Map)this.project.getContextValue("slingstart:global");
        this.packageStandaloneApp(globalContentsMap);
        this.packageWebapp(globalContentsMap);
    }

    private void packageStandaloneApp(Map<String, File> globalContentsMap) throws MojoExecutionException {
        FileInputStream fis;
        block6: {
            this.getLog().info((CharSequence)"Packaging standalone jar...");
            Map contentsMap = (Map)this.project.getContextValue("slingstart:standalone");
            File buildOutputDirectory = this.getStandaloneOutputDirectory();
            File manifestFile = new File(buildOutputDirectory, "META-INF/MANIFEST.MF");
            fis = null;
            try {
                fis = new FileInputStream(manifestFile);
                Manifest mf = new Manifest(fis);
                File outputFile = this.getBuildFile(".jar");
                JarArchiverHelper helper = new JarArchiverHelper(this.jarArchiver, this.project, outputFile, mf);
                helper.addDirectory(buildOutputDirectory, null, EXCLUDES_MANIFEST);
                helper.addArtifacts(globalContentsMap, "");
                helper.addArtifacts(contentsMap, "");
                helper.createArchive();
                if ("slingstart".equals(this.project.getPackaging())) {
                    this.project.getArtifact().setFile(outputFile);
                    break block6;
                }
                if (!this.attachArtifact) {
                    this.getLog().info((CharSequence)"Do not attach the standalone jar to this Maven project");
                    break block6;
                }
                this.projectHelper.attachArtifact(this.project, "jar", "app", outputFile);
            }
            catch (IOException ioe) {
                try {
                    throw new MojoExecutionException("Unable to create standalone jar", (Exception)ioe);
                }
                catch (Throwable throwable) {
                    IOUtils.closeQuietly(fis);
                    throw throwable;
                }
            }
        }
        IOUtils.closeQuietly((InputStream)fis);
    }

    private void packageWebapp(Map<String, File> globalContentsMap) throws MojoExecutionException {
        if (this.createWebapp) {
            this.getLog().info((CharSequence)"Packaging webapp...");
            File buildDirectory = new File(this.project.getBuild().getDirectory());
            Map contentsMap = (Map)this.project.getContextValue("slingstart:webapp");
            File outputFile = this.getBuildFile(".war");
            JarArchiverHelper helper = new JarArchiverHelper(this.jarArchiver, this.project, outputFile);
            File buildOutputDirectory = new File(buildDirectory, "slingstart-webapp");
            helper.addDirectory(buildOutputDirectory, null, EXCLUDES_MANIFEST);
            helper.addArtifacts(globalContentsMap, "WEB-INF/");
            helper.addArtifacts(contentsMap, "WEB-INF/");
            helper.createArchive();
            if (!this.attachArtifact) {
                this.getLog().info((CharSequence)"Do not attach the webapp to this Maven project");
            } else {
                this.projectHelper.attachArtifact(this.project, "war", "webapp", outputFile);
            }
        }
    }

    private File getBuildFile(String extension) {
        File buildDirectory = new File(this.project.getBuild().getDirectory());
        File buildFile = "slingstart".equals(this.project.getPackaging()) ? new File(buildDirectory, this.project.getBuild().getFinalName() + extension) : PackageMojo.getNonPrimaryBuildFile(this.project, extension);
        return buildFile;
    }

    public static File getNonPrimaryBuildFile(MavenProject project, String extension) {
        File buildDirectory = new File(project.getBuild().getDirectory());
        return new File(buildDirectory, project.getBuild().getFinalName() + ".launchpad" + extension);
    }
}

