/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.service;

import com.facebook.fb303.fb_status;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.common.LogUtils;
import org.apache.hadoop.hive.common.ServerUtils;
import org.apache.hadoop.hive.common.cli.CommonCliOptions;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.HiveMetaStore;
import org.apache.hadoop.hive.metastore.TServerSocketKeepAlive;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.hive.metastore.api.Schema;
import org.apache.hadoop.hive.ql.CommandNeedRetryException;
import org.apache.hadoop.hive.ql.Driver;
import org.apache.hadoop.hive.ql.plan.api.QueryPlan;
import org.apache.hadoop.hive.ql.processors.CommandProcessor;
import org.apache.hadoop.hive.ql.processors.CommandProcessorFactory;
import org.apache.hadoop.hive.ql.processors.CommandProcessorResponse;
import org.apache.hadoop.hive.ql.session.SessionState;
import org.apache.hadoop.hive.service.HiveClusterStatus;
import org.apache.hadoop.hive.service.HiveInterface;
import org.apache.hadoop.hive.service.HiveServerException;
import org.apache.hadoop.hive.service.JobTrackerState;
import org.apache.hadoop.hive.service.ThriftHive;
import org.apache.hadoop.hive.shims.ShimLoader;
import org.apache.hadoop.mapred.ClusterStatus;
import org.apache.thrift.TException;
import org.apache.thrift.TProcessor;
import org.apache.thrift.TProcessorFactory;
import org.apache.thrift.protocol.TBinaryProtocol;
import org.apache.thrift.protocol.TProtocolFactory;
import org.apache.thrift.server.TThreadPoolServer;
import org.apache.thrift.transport.TServerSocket;
import org.apache.thrift.transport.TServerTransport;
import org.apache.thrift.transport.TTransport;
import org.apache.thrift.transport.TTransportFactory;

public class HiveServer
extends ThriftHive {
    private static final String VERSION = "1";
    private static final int DEFAULT_HIVE_SERVER_PORT = 10000;
    private static final int DEFAULT_MIN_WORKER_THREADS = 100;
    private static final int DEFAULT_MAX_WORKER_THREADS = Integer.MAX_VALUE;

    public static void main(String[] args) {
        try {
            HiveServerCli cli = new HiveServerCli();
            cli.parse(args);
            Properties hiveconf = cli.addHiveconfToSystemProperties();
            try {
                LogUtils.initHiveLog4j();
            }
            catch (LogUtils.LogInitializationException e) {
                HiveServerHandler.LOG.warn((Object)e.getMessage());
            }
            HiveConf conf = new HiveConf(HiveServerHandler.class);
            ServerUtils.cleanUpScratchDir((HiveConf)conf);
            boolean tcpKeepAlive = conf.getBoolVar(HiveConf.ConfVars.SERVER_TCP_KEEP_ALIVE);
            int timeout = (int)HiveConf.getTimeVar((Configuration)conf, (HiveConf.ConfVars)HiveConf.ConfVars.SERVER_READ_SOCKET_TIMEOUT, (TimeUnit)TimeUnit.MILLISECONDS);
            TServerSocketKeepAlive serverTransport = tcpKeepAlive ? new TServerSocketKeepAlive(cli.port) : new TServerSocket(cli.port, timeout);
            for (Map.Entry<Object, Object> item : hiveconf.entrySet()) {
                conf.set((String)item.getKey(), (String)item.getValue());
            }
            ThriftHiveProcessorFactory hfactory = new ThriftHiveProcessorFactory(null, conf);
            TThreadPoolServer.Args sargs = ((TThreadPoolServer.Args)((TThreadPoolServer.Args)((TThreadPoolServer.Args)new TThreadPoolServer.Args((TServerTransport)serverTransport).processorFactory((TProcessorFactory)hfactory)).transportFactory(new TTransportFactory())).protocolFactory((TProtocolFactory)new TBinaryProtocol.Factory())).minWorkerThreads(cli.minWorkerThreads).maxWorkerThreads(cli.maxWorkerThreads);
            TThreadPoolServer server = new TThreadPoolServer(sargs);
            String msg = "Starting hive server on port " + cli.port + " with " + cli.minWorkerThreads + " min worker threads and " + cli.maxWorkerThreads + " max worker threads";
            HiveServerHandler.LOG.info((Object)msg);
            HiveServerHandler.LOG.info((Object)("TCP keepalive = " + tcpKeepAlive));
            if (cli.isVerbose()) {
                System.err.println(msg);
            }
            server.serve();
        }
        catch (Exception x) {
            x.printStackTrace();
        }
    }

    public static class HiveServerCli
    extends CommonCliOptions {
        private static final String OPTION_MAX_WORKER_THREADS = "maxWorkerThreads";
        private static final String OPTION_MIN_WORKER_THREADS = "minWorkerThreads";
        public int port = 10000;
        public int minWorkerThreads = 100;
        public int maxWorkerThreads = Integer.MAX_VALUE;

        public HiveServerCli() {
            super("hiveserver", true);
            OptionBuilder.hasArg();
            OptionBuilder.withArgName((String)"port");
            OptionBuilder.withDescription((String)"Hive Server port number, default:10000");
            this.OPTIONS.addOption(OptionBuilder.create((char)'p'));
            OptionBuilder.hasArg();
            OptionBuilder.withLongOpt((String)OPTION_MIN_WORKER_THREADS);
            OptionBuilder.withDescription((String)"minimum number of worker threads, default:100");
            this.OPTIONS.addOption(OptionBuilder.create());
            OptionBuilder.hasArg();
            OptionBuilder.withLongOpt((String)OPTION_MAX_WORKER_THREADS);
            OptionBuilder.withDescription((String)"maximum number of worker threads, default:2147483647");
            this.OPTIONS.addOption(OptionBuilder.create());
        }

        public void parse(String[] args) {
            super.parse(args);
            args = this.commandLine.getArgs();
            if (args.length >= 1) {
                System.err.println("This usage has been deprecated, consider using the new command line syntax (run with -h to see usage information)");
                this.port = Integer.parseInt(args[0]);
            }
            if (args.length >= 2) {
                this.minWorkerThreads = Integer.parseInt(args[1]);
            }
            if (this.commandLine.hasOption('p')) {
                this.port = Integer.parseInt(this.commandLine.getOptionValue('p'));
            } else {
                String hivePort = System.getenv("HIVE_PORT");
                if (hivePort != null) {
                    this.port = Integer.parseInt(hivePort);
                }
            }
            if (this.commandLine.hasOption(OPTION_MIN_WORKER_THREADS)) {
                this.minWorkerThreads = Integer.parseInt(this.commandLine.getOptionValue(OPTION_MIN_WORKER_THREADS));
            }
            if (this.commandLine.hasOption(OPTION_MAX_WORKER_THREADS)) {
                this.maxWorkerThreads = Integer.parseInt(this.commandLine.getOptionValue(OPTION_MAX_WORKER_THREADS));
            }
        }
    }

    public static class ThriftHiveProcessorFactory
    extends TProcessorFactory {
        private final HiveConf conf;

        public ThriftHiveProcessorFactory(TProcessor processor, HiveConf conf) {
            super(processor);
            this.conf = conf;
        }

        public TProcessor getProcessor(TTransport trans) {
            try {
                HiveServerHandler handler = new HiveServerHandler(new HiveConf(this.conf));
                return new ThriftHive.Processor<HiveServerHandler>(handler);
            }
            catch (Exception e) {
                HiveServerHandler.LOG.warn((Object)("Failed to get processor by exception " + e), (Throwable)e);
                trans.close();
                throw new RuntimeException(e);
            }
        }
    }

    public static class HiveServerHandler
    extends HiveMetaStore.HMSHandler
    implements HiveInterface {
        private Driver driver = null;
        private CommandProcessorResponse response;
        private BufferedReader pipeIn;
        private boolean isHiveQuery = false;
        public static final Log LOG = LogFactory.getLog((String)HiveServer.class.getName());

        public HiveServerHandler() throws MetaException {
            this(new HiveConf(SessionState.class));
        }

        public HiveServerHandler(HiveConf conf) throws MetaException {
            super(HiveServer.class.getName(), conf);
            SessionState session = new SessionState(conf);
            SessionState.start((SessionState)session);
            this.setupSessionIO(session);
        }

        private void setupSessionIO(SessionState session) {
            try {
                LOG.info((Object)("Putting temp output to file " + session.getTmpOutputFile().toString()));
                session.in = null;
                session.out = new PrintStream((OutputStream)new FileOutputStream(session.getTmpOutputFile()), true, "UTF-8");
                session.err = new PrintStream((OutputStream)System.err, true, "UTF-8");
            }
            catch (IOException e) {
                LOG.error((Object)"Error in creating temp output file ", (Throwable)e);
                try {
                    session.in = null;
                    session.out = new PrintStream((OutputStream)System.out, true, "UTF-8");
                    session.err = new PrintStream((OutputStream)System.err, true, "UTF-8");
                }
                catch (UnsupportedEncodingException ee) {
                    ee.printStackTrace();
                    session.out = null;
                    session.err = null;
                }
            }
        }

        @Override
        public void execute(String cmd) throws HiveServerException, TException {
            LOG.info((Object)("Running the query: " + cmd));
            SessionState session = SessionState.get();
            String cmd_trimmed = cmd.trim();
            String[] tokens = cmd_trimmed.split("\\s");
            String cmd_1 = cmd_trimmed.substring(tokens[0].length()).trim();
            int ret = 0;
            String errorMessage = "";
            String SQLState = null;
            try {
                CommandProcessor proc;
                if (this.driver != null) {
                    this.driver.close();
                    this.driver = null;
                }
                if ((proc = CommandProcessorFactory.get((String)tokens[0])) != null) {
                    if (proc instanceof Driver) {
                        this.isHiveQuery = true;
                        this.driver = (Driver)proc;
                        this.driver.setTryCount(Integer.MAX_VALUE);
                        this.response = this.driver.run(cmd);
                    } else {
                        this.isHiveQuery = false;
                        this.driver = null;
                        this.setupSessionIO(session);
                        this.response = proc.run(cmd_1);
                    }
                    ret = this.response.getResponseCode();
                    SQLState = this.response.getSQLState();
                    errorMessage = this.response.getErrorMessage();
                }
            }
            catch (Exception e) {
                HiveServerException ex = new HiveServerException();
                ex.setMessage("Error running query: " + e.toString());
                ex.setErrorCode(ret == 0 ? -10000 : ret);
                throw ex;
            }
            if (ret != 0) {
                throw new HiveServerException("Query returned non-zero code: " + ret + ", cause: " + errorMessage, ret, SQLState);
            }
        }

        @Override
        public void clean() {
            SessionState session;
            if (this.driver != null) {
                this.driver.close();
                this.driver.destroy();
            }
            if ((session = SessionState.get()).getTmpOutputFile() != null) {
                session.getTmpOutputFile().delete();
            }
            this.pipeIn = null;
        }

        @Override
        public HiveClusterStatus getClusterStatus() throws HiveServerException, TException {
            HiveClusterStatus hcs;
            try {
                Driver drv = new Driver();
                drv.init();
                ClusterStatus cs = drv.getClusterStatus();
                JobTrackerState state = JobTrackerState.valueOf(ShimLoader.getHadoopShims().getJobTrackerState(cs).name());
                hcs = new HiveClusterStatus(cs.getTaskTrackers(), cs.getMapTasks(), cs.getReduceTasks(), cs.getMaxMapTasks(), cs.getMaxReduceTasks(), state);
            }
            catch (Exception e) {
                LOG.error((Object)e.toString());
                e.printStackTrace();
                HiveServerException ex = new HiveServerException();
                ex.setMessage("Unable to get cluster status: " + e.toString());
                throw ex;
            }
            return hcs;
        }

        @Override
        public Schema getSchema() throws HiveServerException, TException {
            if (!this.isHiveQuery) {
                Schema schema = this.response.getSchema();
                if (schema == null) {
                    return new Schema();
                }
                return schema;
            }
            assert (this.driver != null) : "getSchema() is called on a Hive query and driver is NULL.";
            try {
                Schema schema = this.driver.getSchema();
                if (schema == null) {
                    schema = new Schema();
                }
                LOG.info((Object)("Returning schema: " + schema));
                return schema;
            }
            catch (Exception e) {
                LOG.error((Object)e.toString());
                e.printStackTrace();
                HiveServerException ex = new HiveServerException();
                ex.setMessage("Unable to get schema: " + e.toString());
                throw ex;
            }
        }

        @Override
        public Schema getThriftSchema() throws HiveServerException, TException {
            if (!this.isHiveQuery) {
                return new Schema();
            }
            assert (this.driver != null) : "getThriftSchema() is called on a Hive query and driver is NULL.";
            try {
                Schema schema = this.driver.getThriftSchema();
                if (schema == null) {
                    schema = new Schema();
                }
                LOG.info((Object)("Returning schema: " + schema));
                return schema;
            }
            catch (Exception e) {
                LOG.error((Object)e.toString());
                e.printStackTrace();
                HiveServerException ex = new HiveServerException();
                ex.setMessage("Unable to get schema: " + e.toString());
                throw ex;
            }
        }

        @Override
        public String fetchOne() throws HiveServerException, TException {
            if (!this.isHiveQuery) {
                ArrayList<String> results = new ArrayList<String>(1);
                this.readResults(results, 1);
                if (results.size() > 0) {
                    return (String)results.get(0);
                }
                throw new HiveServerException("OK", 0, "");
            }
            assert (this.driver != null) : "fetchOne() is called on a Hive query and driver is NULL.";
            ArrayList result = new ArrayList();
            this.driver.setMaxRows(1);
            try {
                if (this.driver.getResults(result)) {
                    return (String)result.get(0);
                }
                throw new HiveServerException("OK", 0, "");
            }
            catch (CommandNeedRetryException e) {
                HiveServerException ex = new HiveServerException();
                ex.setMessage(e.getMessage());
                throw ex;
            }
            catch (IOException e) {
                HiveServerException ex = new HiveServerException();
                ex.setMessage(e.getMessage());
                throw ex;
            }
        }

        private void cleanTmpFile() {
            if (this.pipeIn != null) {
                SessionState session = SessionState.get();
                File tmp = session.getTmpOutputFile();
                tmp.delete();
                this.pipeIn = null;
            }
        }

        private void readResults(List<String> results, int nLines) {
            if (this.pipeIn == null) {
                SessionState session = SessionState.get();
                File tmp = session.getTmpOutputFile();
                try {
                    this.pipeIn = new BufferedReader(new FileReader(tmp));
                }
                catch (FileNotFoundException e) {
                    LOG.error((Object)("File " + tmp + " not found. "), (Throwable)e);
                    return;
                }
            }
            boolean readAll = false;
            for (int i = 0; i < nLines || nLines <= 0; ++i) {
                try {
                    String line = this.pipeIn.readLine();
                    if (line == null) {
                        readAll = true;
                        break;
                    }
                    results.add(line);
                    continue;
                }
                catch (IOException e) {
                    LOG.error((Object)"Reading temp results encountered an exception: ", (Throwable)e);
                    readAll = true;
                }
            }
            if (readAll) {
                this.cleanTmpFile();
            }
        }

        @Override
        public List<String> fetchN(int numRows) throws HiveServerException, TException {
            if (numRows < 0) {
                HiveServerException ex = new HiveServerException();
                ex.setMessage("Invalid argument for number of rows: " + numRows);
                throw ex;
            }
            ArrayList<String> result = new ArrayList<String>();
            if (!this.isHiveQuery) {
                this.readResults(result, numRows);
                return result;
            }
            assert (this.driver != null) : "fetchN() is called on a Hive query and driver is NULL.";
            this.driver.setMaxRows(numRows);
            try {
                this.driver.getResults(result);
            }
            catch (CommandNeedRetryException e) {
                HiveServerException ex = new HiveServerException();
                ex.setMessage(e.getMessage());
                throw ex;
            }
            catch (IOException e) {
                HiveServerException ex = new HiveServerException();
                ex.setMessage(e.getMessage());
                throw ex;
            }
            return result;
        }

        @Override
        public List<String> fetchAll() throws HiveServerException, TException {
            ArrayList<String> rows = new ArrayList<String>();
            ArrayList<String> result = new ArrayList<String>();
            if (!this.isHiveQuery) {
                this.readResults(result, 0);
                return result;
            }
            try {
                while (this.driver.getResults(result)) {
                    rows.addAll(result);
                    result.clear();
                }
            }
            catch (CommandNeedRetryException e) {
                HiveServerException ex = new HiveServerException();
                ex.setMessage(e.getMessage());
                throw ex;
            }
            catch (IOException e) {
                HiveServerException ex = new HiveServerException();
                ex.setMessage(e.getMessage());
                throw ex;
            }
            return rows;
        }

        public fb_status getStatus() {
            return fb_status.ALIVE;
        }

        public String getVersion() {
            return HiveServer.VERSION;
        }

        @Override
        public QueryPlan getQueryPlan() throws HiveServerException, TException {
            QueryPlan qp = new QueryPlan();
            if (!this.isHiveQuery) {
                return qp;
            }
            assert (this.driver != null) : "getQueryPlan() is called on a Hive query and driver is NULL.";
            try {
                qp.addToQueries(this.driver.getQueryPlan());
            }
            catch (Exception e) {
                HiveServerException ex = new HiveServerException();
                ex.setMessage(e.toString());
                throw ex;
            }
            return qp;
        }
    }
}

