/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.hcatalog.streaming;

import java.io.IOException;
import java.util.Random;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.HiveMetaStoreClient;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.hive.metastore.api.NoSuchObjectException;
import org.apache.hadoop.hive.metastore.api.Table;
import org.apache.hadoop.hive.ql.io.AcidOutputFormat;
import org.apache.hadoop.hive.ql.io.RecordUpdater;
import org.apache.hadoop.hive.serde2.SerDe;
import org.apache.hadoop.hive.serde2.SerDeException;
import org.apache.hadoop.util.ReflectionUtils;
import org.apache.hive.hcatalog.streaming.ConnectionError;
import org.apache.hive.hcatalog.streaming.DelimitedInputWriter;
import org.apache.hive.hcatalog.streaming.HiveEndPoint;
import org.apache.hive.hcatalog.streaming.RecordWriter;
import org.apache.hive.hcatalog.streaming.SerializationError;
import org.apache.hive.hcatalog.streaming.StreamingException;
import org.apache.hive.hcatalog.streaming.StreamingIOFailure;
import org.apache.thrift.TException;

abstract class AbstractRecordWriter
implements RecordWriter {
    private static final Log LOG = LogFactory.getLog((String)AbstractRecordWriter.class.getName());
    final HiveConf conf;
    final HiveEndPoint endPoint;
    final Table tbl;
    final HiveMetaStoreClient msClient;
    RecordUpdater updater = null;
    private final int totalBuckets;
    private Random rand = new Random();
    private int currentBucketId = 0;
    private final Path partitionPath;
    final AcidOutputFormat<?, ?> outf;

    protected AbstractRecordWriter(HiveEndPoint endPoint, HiveConf conf) throws ConnectionError, StreamingException {
        this.endPoint = endPoint;
        this.conf = conf != null ? conf : HiveEndPoint.createHiveConf(DelimitedInputWriter.class, endPoint.metaStoreUri);
        try {
            this.msClient = new HiveMetaStoreClient(this.conf);
            this.tbl = this.msClient.getTable(endPoint.database, endPoint.table);
            this.partitionPath = this.getPathForEndPoint(this.msClient, endPoint);
            this.totalBuckets = this.tbl.getSd().getNumBuckets();
            if (this.totalBuckets <= 0) {
                throw new StreamingException("Cannot stream to table that has not been bucketed : " + endPoint);
            }
            String outFormatName = this.tbl.getSd().getOutputFormat();
            this.outf = (AcidOutputFormat)ReflectionUtils.newInstance(Class.forName(outFormatName), (Configuration)conf);
        }
        catch (MetaException e) {
            throw new ConnectionError(endPoint, (Exception)((Object)e));
        }
        catch (NoSuchObjectException e) {
            throw new ConnectionError(endPoint, (Exception)((Object)e));
        }
        catch (TException e) {
            throw new StreamingException(e.getMessage(), (Exception)((Object)e));
        }
        catch (ClassNotFoundException e) {
            throw new StreamingException(e.getMessage(), e);
        }
    }

    protected AbstractRecordWriter(HiveEndPoint endPoint) throws ConnectionError, StreamingException {
        this(endPoint, HiveEndPoint.createHiveConf(AbstractRecordWriter.class, endPoint.metaStoreUri));
    }

    abstract SerDe getSerde() throws SerializationError;

    @Override
    public void flush() throws StreamingIOFailure {
        try {
            this.updater.flush();
        }
        catch (IOException e) {
            throw new StreamingIOFailure("Unable to flush recordUpdater", e);
        }
    }

    @Override
    public void clear() throws StreamingIOFailure {
    }

    @Override
    public void newBatch(Long minTxnId, Long maxTxnID) throws StreamingIOFailure, SerializationError {
        try {
            this.currentBucketId = this.rand.nextInt(this.totalBuckets);
            LOG.debug((Object)"Creating Record updater");
            this.updater = this.createRecordUpdater(this.currentBucketId, minTxnId, maxTxnID);
        }
        catch (IOException e) {
            LOG.error((Object)"Failed creating record updater", (Throwable)e);
            throw new StreamingIOFailure("Unable to get new record Updater", e);
        }
    }

    @Override
    public void closeBatch() throws StreamingIOFailure {
        try {
            this.updater.close(false);
            this.updater = null;
        }
        catch (IOException e) {
            throw new StreamingIOFailure("Unable to close recordUpdater", e);
        }
    }

    private RecordUpdater createRecordUpdater(int bucketId, Long minTxnId, Long maxTxnID) throws IOException, SerializationError {
        try {
            return this.outf.getRecordUpdater(this.partitionPath, new AcidOutputFormat.Options((Configuration)this.conf).inspector(this.getSerde().getObjectInspector()).bucket(bucketId).minimumTransactionId(minTxnId.longValue()).maximumTransactionId(maxTxnID.longValue()));
        }
        catch (SerDeException e) {
            throw new SerializationError("Failed to get object inspector from Serde " + this.getSerde().getClass().getName(), (Exception)((Object)e));
        }
    }

    private Path getPathForEndPoint(HiveMetaStoreClient msClient, HiveEndPoint endPoint) throws StreamingException {
        try {
            String location = endPoint.partitionVals == null || endPoint.partitionVals.isEmpty() ? msClient.getTable(endPoint.database, endPoint.table).getSd().getLocation() : msClient.getPartition(endPoint.database, endPoint.table, endPoint.partitionVals).getSd().getLocation();
            return new Path(location);
        }
        catch (TException e) {
            throw new StreamingException(e.getMessage() + ". Unable to get path for end point: " + endPoint.partitionVals, (Exception)((Object)e));
        }
    }
}

