/*
 * Decompiled with CFR 0.152.
 */
package com.google.gxp.compiler.parser;

import com.google.gxp.com.google.common.base.Preconditions;
import com.google.gxp.com.google.common.collect.ImmutableList;
import com.google.gxp.com.google.common.collect.Lists;
import com.google.gxp.compiler.alerts.Alert;
import com.google.gxp.compiler.alerts.AlertSet;
import com.google.gxp.compiler.alerts.AlertSink;
import com.google.gxp.compiler.alerts.SourcePosition;
import com.google.gxp.compiler.parser.AdditionalRootElementError;
import com.google.gxp.compiler.parser.IgnoredXmlWarning;
import com.google.gxp.compiler.parser.Namespace;
import com.google.gxp.compiler.parser.NamespaceSet;
import com.google.gxp.compiler.parser.NullNamespace;
import com.google.gxp.compiler.parser.ParsedAttribute;
import com.google.gxp.compiler.parser.ParsedElement;
import com.google.gxp.compiler.parser.SourceEntityResolver;
import com.google.gxp.compiler.parser.TextElement;
import com.google.gxp.compiler.parser.UndefinedEntityError;
import com.google.gxp.compiler.parser.XmlEventHandler;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.List;

class DefaultXmlEventHandler
implements XmlEventHandler {
    private final NamespaceSet namespaces;
    private final AlertSink alertSink;
    private final SourceEntityResolver entityResolver;
    private final Deque<ElementBuilder> builderStack = new ArrayDeque<ElementBuilder>();
    private List<ParsedElement> rootElements = Lists.newArrayList();

    public DefaultXmlEventHandler(NamespaceSet namespaces, AlertSink alertSink, SourceEntityResolver entityResolver) {
        this.namespaces = Preconditions.checkNotNull(namespaces);
        this.alertSink = Preconditions.checkNotNull(alertSink);
        this.entityResolver = Preconditions.checkNotNull(entityResolver);
    }

    List<ParsedElement> getParsedRoots() {
        while (!this.builderStack.isEmpty()) {
            this.consumeElement(this.builderStack.pop().build());
        }
        return this.rootElements;
    }

    @Override
    public void add(Alert alert) {
        this.alertSink.add(alert);
    }

    @Override
    public void addAll(AlertSet alertSet) {
        this.alertSink.addAll(alertSet);
    }

    @Override
    public void startPrefixMapping(SourcePosition sourcePosition, String prefix, String uri) {
    }

    @Override
    public void endPrefixMapping(SourcePosition sourcePosition, String prefix) {
    }

    @Override
    public void startElement(SourcePosition sourcePosition, String nsUri, String localName, String qName, Iterable<? extends ParsedAttribute> attrs) {
        this.builderStack.push(new ElementBuilder(this.alertSink, sourcePosition, this.namespaces, nsUri, localName, qName, attrs));
    }

    @Override
    public void endElement(SourcePosition sourcePosition, String nsUri, String localName, String qName) {
        ElementBuilder builder = this.builderStack.pop();
        builder.checkEndTag(nsUri, localName, qName);
        this.consumeElement(builder.build());
    }

    private void consumeElement(ParsedElement element) {
        if (element != null) {
            if (this.builderStack.isEmpty()) {
                if (!this.rootElements.isEmpty()) {
                    this.alertSink.add(new AdditionalRootElementError(element.getSourcePosition(), this.rootElements.get(0), element));
                }
                this.rootElements.add(element);
            } else {
                this.builderStack.peek().addChild(element);
            }
        }
    }

    @Override
    public void characters(SourcePosition sourcePosition, char[] ch, int start, int length) {
        this.builderStack.peek().addText(sourcePosition, ch, start, length);
    }

    @Override
    public void processingInstruction(SourcePosition sourcePosition, String target, String data) {
        this.alertSink.add(new IgnoredXmlWarning(sourcePosition, "processing instruction"));
    }

    @Override
    public void skippedEntity(SourcePosition sourcePosition, String name) {
        this.alertSink.add(new UndefinedEntityError(sourcePosition, name));
    }

    @Override
    public void notationDecl(SourcePosition sourcePosition, String name, String publicId, String systemId) {
        this.alertSink.add(new IgnoredXmlWarning(sourcePosition, "notation declaration"));
    }

    @Override
    public void unparsedEntityDecl(SourcePosition sourcePosition, String name, String publicId, String systemId, String notationName) {
        this.alertSink.add(new IgnoredXmlWarning(sourcePosition, "unparsed entity declaration"));
    }

    @Override
    public InputStream resolveEntity(SourcePosition sourcePosition, String publicId, String systemId) throws IOException {
        return this.entityResolver.resolveEntity(sourcePosition, publicId, systemId, this.alertSink);
    }

    @Override
    public ParsedAttribute parseAttribute(SourcePosition sourcePosition, String nsUri, String name, String value, String qName) {
        Namespace namespace = nsUri == null ? NullNamespace.INSTANCE : this.namespaces.get(this, sourcePosition, nsUri);
        return namespace == null ? null : new ParsedAttribute(sourcePosition, namespace, name, value, qName);
    }

    private static class ElementBuilder {
        private final AlertSink alertSink;
        private final NamespaceSet namespaces;
        private final SourcePosition elementPosition;
        private final String uri;
        private final String localName;
        private final String qName;
        private final List<ParsedAttribute> attrs;
        private final List<ParsedElement> children = Lists.newArrayList();
        private final StringBuilder textBuffer = new StringBuilder();
        private SourcePosition textPosition;

        ElementBuilder(AlertSink alertSink, SourcePosition elementPosition, NamespaceSet namespaces, String uri, String localName, String qName, Iterable<? extends ParsedAttribute> attrs) {
            this.alertSink = alertSink;
            this.namespaces = namespaces;
            this.elementPosition = elementPosition;
            this.uri = uri;
            this.localName = localName;
            this.qName = qName;
            this.attrs = ImmutableList.copyOf(attrs);
        }

        public void addChild(ParsedElement child) {
            this.flushTextBuffer();
            this.children.add(Preconditions.checkNotNull(child));
        }

        void checkEndTag(String endUri, String endLocalName, String endQName) {
            if (!endUri.equals(this.uri)) {
                throw new IllegalArgumentException();
            }
            if (!endLocalName.equals(this.localName)) {
                throw new IllegalArgumentException();
            }
            if (!endQName.equals(this.qName)) {
                throw new IllegalArgumentException();
            }
        }

        ParsedElement build() {
            Namespace ns = this.namespaces.get(this.alertSink, this.elementPosition, this.uri);
            if (ns == null) {
                return null;
            }
            this.flushTextBuffer();
            return ns.createElement(this.alertSink, this.elementPosition, ElementBuilder.tagDisplayName(this.qName), this.localName, this.attrs, this.children);
        }

        private static String tagDisplayName(String qName) {
            return "<" + qName + ">";
        }

        public void addText(SourcePosition sourcePosition, char[] ch, int start, int length) {
            if (this.textPosition == null) {
                this.textPosition = sourcePosition;
            }
            this.textBuffer.append(ch, start, length);
        }

        private void flushTextBuffer() {
            if (this.textBuffer.length() > 0) {
                if (this.textPosition == null) {
                    throw new NullPointerException();
                }
                String text = this.textBuffer.toString();
                this.textBuffer.setLength(0);
                this.children.add(new TextElement(this.textPosition, text));
                this.textPosition = null;
            }
        }
    }
}

