/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tiles.autotag.tool;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.tiles.autotag.core.AutotagRuntimeException;

public class StringTool {
    private Map<String, String> type2default = new HashMap<String, String>();
    private Map<String, String> primitive2wrapped;

    public StringTool() {
        this.type2default.put("byte", "0");
        this.type2default.put("short", "0");
        this.type2default.put("int", "0");
        this.type2default.put("long", "0L");
        this.type2default.put("float", "0.0f");
        this.type2default.put("double", "0.0d");
        this.type2default.put("char", "'\\u0000'");
        this.type2default.put("boolean", "false");
        this.primitive2wrapped = new HashMap<String, String>();
        this.primitive2wrapped.put("byte", Byte.class.getName());
        this.primitive2wrapped.put("short", Short.class.getName());
        this.primitive2wrapped.put("int", Integer.class.getName());
        this.primitive2wrapped.put("long", Long.class.getName());
        this.primitive2wrapped.put("float", Float.class.getName());
        this.primitive2wrapped.put("double", Double.class.getName());
        this.primitive2wrapped.put("char", Character.class.getName());
        this.primitive2wrapped.put("boolean", Boolean.class.getName());
    }

    public List<String> splitOnNewlines(String toSplit) {
        ArrayList<String> retValue = new ArrayList<String>();
        if (toSplit == null) {
            return retValue;
        }
        StringReader reader = new StringReader(toSplit);
        BufferedReader bufReader = new BufferedReader(reader);
        try {
            String line;
            while ((line = bufReader.readLine()) != null) {
                retValue.add(line);
            }
        }
        catch (IOException e) {
            throw new AutotagRuntimeException("Cannot read the string completely", e);
        }
        return retValue;
    }

    public String capitalizeFirstLetter(String string) {
        return string.substring(0, 1).toUpperCase() + string.substring(1);
    }

    public String getDefaultValue(String type, String overriddenDefaultValue) {
        if (overriddenDefaultValue != null) {
            return overriddenDefaultValue;
        }
        String retValue = this.type2default.get(type);
        if (retValue == null) {
            retValue = "null";
        }
        return retValue;
    }

    public String getClassToCast(String type) {
        String retValue = this.primitive2wrapped.get(type);
        if (retValue == null) {
            retValue = type;
        }
        return retValue;
    }
}

