/*
 * Decompiled with CFR 0.152.
 */
package com.google.gxp.compiler.schema;

import com.google.gxp.com.google.common.base.Preconditions;
import com.google.gxp.com.google.common.base.Supplier;
import com.google.gxp.com.google.common.base.Suppliers;
import com.google.gxp.com.google.common.collect.MapConstraints;
import com.google.gxp.com.google.common.collect.Maps;
import com.google.gxp.compiler.alerts.AlertSink;
import com.google.gxp.compiler.fs.FileRef;
import com.google.gxp.compiler.schema.DuplicateContentTypeSchemaError;
import com.google.gxp.compiler.schema.Schema;
import com.google.gxp.compiler.schema.SchemaFactory;
import com.google.gxp.compiler.schema.SchemaParser;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class FileBackedSchemaFactory
implements SchemaFactory {
    private final AlertSink alertSink;
    private final Map<String, Supplier<Schema>> byNamespaceUri;
    private final Map<String, Supplier<Schema>> byContentTypeName;

    public FileBackedSchemaFactory(AlertSink alertSink, Iterable<FileRef> schemaRefs) {
        this.alertSink = Preconditions.checkNotNull(alertSink);
        this.byNamespaceUri = FileBackedSchemaFactory.createMap();
        this.byContentTypeName = FileBackedSchemaFactory.createMap();
        for (FileRef ref : schemaRefs) {
            this.addSchema(ref);
        }
    }

    public FileBackedSchemaFactory(AlertSink alertSink) {
        this(alertSink, Collections.emptySet());
    }

    private static <K, V> Map<K, V> createMap() {
        HashMap map = Maps.newHashMap();
        return MapConstraints.constrainedMap(map, MapConstraints.NOT_NULL);
    }

    public void addSchemaPromise(final FileRef ref, String nsUri, String ... contentTypeNames) {
        Supplier<Schema> supplier = Suppliers.memoize(new Supplier<Schema>(){

            @Override
            public Schema get() {
                return SchemaParser.getSchema(ref, FileBackedSchemaFactory.this.alertSink);
            }
        });
        this.byNamespaceUri.put(nsUri, supplier);
        for (String another : contentTypeNames) {
            this.byContentTypeName.put(another, supplier);
        }
    }

    public void addSchema(FileRef ref) {
        Schema schema = SchemaParser.getSchema(ref, this.alertSink);
        Supplier<Schema> supplier = Suppliers.ofInstance(schema);
        this.byNamespaceUri.put(schema.getNamespaceUri(), supplier);
        this.addSupplierForContentType(schema.getXmlContentType(), supplier);
        this.addSupplierForContentType(schema.getSgmlContentType(), supplier);
    }

    private void addSupplierForContentType(String contentTypeName, Supplier<Schema> supplier) {
        if (contentTypeName != null) {
            if (this.byContentTypeName.containsKey(contentTypeName)) {
                this.alertSink.add(new DuplicateContentTypeSchemaError(supplier.get(), contentTypeName));
            } else {
                this.byContentTypeName.put(contentTypeName, supplier);
            }
        }
    }

    @Override
    public Schema fromNamespaceUri(String nsUri) {
        Supplier<Schema> supplier = this.byNamespaceUri.get(Preconditions.checkNotNull(nsUri));
        return supplier == null ? null : supplier.get();
    }

    @Override
    public Schema fromContentTypeName(String contentTypeName) {
        Supplier<Schema> supplier = this.byContentTypeName.get(Preconditions.checkNotNull(contentTypeName));
        return supplier == null ? null : supplier.get();
    }
}

