/*
 * Decompiled with CFR 0.152.
 */
package org.apache.struts2.views.jasperreports7.export;

import jakarta.servlet.ServletOutputStream;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.OutputStream;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.export.ooxml.JRXlsxExporter;
import net.sf.jasperreports.export.ExporterInput;
import net.sf.jasperreports.export.ExporterOutput;
import net.sf.jasperreports.export.SimpleExporterInput;
import net.sf.jasperreports.export.SimpleOutputStreamExporterOutput;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.struts2.ActionInvocation;
import org.apache.struts2.StrutsException;
import org.apache.struts2.views.jasperreports7.export.JasperReport7ExporterProvider;

public class JasperReport7XlsxExporterProvider
implements JasperReport7ExporterProvider<JRXlsxExporter> {
    private static final Logger LOG = LogManager.getLogger(JasperReport7XlsxExporterProvider.class);

    @Override
    public JRXlsxExporter createExporter(ActionInvocation invocation, JasperPrint jasperPrint) throws StrutsException {
        LOG.debug("Creating: {} exporter", (Object)this.getClass().getSimpleName());
        HttpServletResponse response = invocation.getInvocationContext().getServletResponse();
        response.setContentType("application/vnd.openxmlformats-officedocument.spreadsheetml.sheet");
        JRXlsxExporter exporter = new JRXlsxExporter();
        SimpleExporterInput input = new SimpleExporterInput(jasperPrint);
        exporter.setExporterInput((ExporterInput)input);
        try (ServletOutputStream responseStream = response.getOutputStream();){
            SimpleOutputStreamExporterOutput exporterOutput = new SimpleOutputStreamExporterOutput((OutputStream)responseStream);
            exporter.setExporterOutput((ExporterOutput)exporterOutput);
        }
        catch (IOException e) {
            LOG.error("Error writing XLSX report output using: {}", (Object)JasperReport7XlsxExporterProvider.class.getName(), (Object)e);
            throw new StrutsException(e.getMessage(), (Throwable)e);
        }
        return exporter;
    }
}

