/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.base;

import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import net.sf.jasperreports.engine.JRChild;
import net.sf.jasperreports.engine.JRElement;
import net.sf.jasperreports.engine.JRExpressionCollector;
import net.sf.jasperreports.engine.JRFrame;
import net.sf.jasperreports.engine.JRLineBox;
import net.sf.jasperreports.engine.JRVisitor;
import net.sf.jasperreports.engine.base.JRBaseElement;
import net.sf.jasperreports.engine.base.JRBaseElementGroup;
import net.sf.jasperreports.engine.base.JRBaseObjectFactory;
import net.sf.jasperreports.engine.type.BorderSplitType;
import net.sf.jasperreports.engine.type.ModeEnum;
import net.sf.jasperreports.engine.util.ElementsVisitorUtils;

public class JRBaseFrame
extends JRBaseElement
implements JRFrame {
    private static final long serialVersionUID = 10200L;
    protected List<JRChild> children;
    protected JRLineBox lineBox;
    private BorderSplitType borderSplitType;

    public JRBaseFrame(JRFrame frame, JRBaseObjectFactory factory) {
        super(frame, factory);
        List<JRChild> frameChildren = frame.getChildren();
        if (frameChildren != null) {
            this.children = new ArrayList<JRChild>(frameChildren.size());
            for (JRChild child : frameChildren) {
                this.children.add((JRChild)factory.getVisitResult(child));
            }
        }
        this.lineBox = frame.getLineBox().clone(this);
        this.borderSplitType = frame.getBorderSplitType();
    }

    @Override
    public JRElement[] getElements() {
        return JRBaseElementGroup.getElements(this.children);
    }

    @Override
    public void collectExpressions(JRExpressionCollector collector) {
        collector.collect(this);
    }

    @Override
    public void visit(JRVisitor visitor) {
        visitor.visitFrame(this);
        if (ElementsVisitorUtils.visitDeepElements(visitor)) {
            ElementsVisitorUtils.visitElements(visitor, this.children);
        }
    }

    @Override
    public List<JRChild> getChildren() {
        return this.children;
    }

    @Override
    public JRElement getElementByKey(String elementKey) {
        return JRBaseElementGroup.getElementByKey(this.getElements(), elementKey);
    }

    @Override
    public ModeEnum getMode() {
        return this.getStyleResolver().getMode(this, ModeEnum.TRANSPARENT);
    }

    @Override
    public JRLineBox getLineBox() {
        return this.lineBox;
    }

    @Override
    public Color getDefaultLineColor() {
        return this.getForecolor();
    }

    @Override
    public BorderSplitType getBorderSplitType() {
        return this.borderSplitType;
    }

    @Override
    public Object clone() {
        JRBaseFrame clone = (JRBaseFrame)super.clone();
        if (this.children != null) {
            clone.children = new ArrayList<JRChild>(this.children.size());
            for (int i = 0; i < this.children.size(); ++i) {
                clone.children.add((JRChild)this.children.get(i).clone(clone));
            }
        }
        return clone;
    }
}

