/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.export;

import java.io.UnsupportedEncodingException;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRRuntimeException;
import net.sf.jasperreports.engine.JasperReportsContext;
import net.sf.jasperreports.engine.export.HtmlFont;
import net.sf.jasperreports.engine.export.HtmlFontFamily;
import net.sf.jasperreports.engine.export.HtmlResourceHandler;
import net.sf.jasperreports.engine.fonts.FontFace;
import net.sf.jasperreports.engine.fonts.FontFamily;
import net.sf.jasperreports.repo.RepositoryUtil;

public class HtmlFontUtil {
    public static final String CSS_RESOURCE_EXTENSION = ".css";
    private final RepositoryUtil repositoryUtil;

    private HtmlFontUtil(JasperReportsContext jasperReportsContext) {
        this.repositoryUtil = RepositoryUtil.getInstance(jasperReportsContext);
    }

    public static HtmlFontUtil getInstance(JasperReportsContext jasperReportsContext) {
        return new HtmlFontUtil(jasperReportsContext);
    }

    private String getHtmlFont(HtmlResourceHandler fontPathProvider, HtmlResourceHandler fontResourceSaver, HtmlFont htmlFont, boolean useShortId, boolean useLocal) {
        StringBuilder sb = new StringBuilder();
        try {
            sb.append("@font-face {\n");
            sb.append("\tfont-family: '");
            sb.append(useShortId ? (htmlFont.getFamily() == null ? htmlFont.getShortId() : htmlFont.getFamily().getShortId()) : (htmlFont.getFamily() == null ? htmlFont.getId() : htmlFont.getFamily().getId()));
            sb.append("';\n");
            if (htmlFont.getEot() != null) {
                String eotId;
                String eotFileName = eotId = htmlFont.getId() + ".eot";
                if (fontPathProvider != null) {
                    eotFileName = fontPathProvider.getResourcePath(eotId);
                }
                if (fontResourceSaver != null) {
                    fontResourceSaver.handleResource(eotId, this.repositoryUtil.getBytesFromLocation(htmlFont.getEot()));
                }
                sb.append("\tsrc: url('" + eotFileName + "');\n");
                sb.append("\tsrc: url('" + eotFileName + "?#iefix') format('embedded-opentype');\n");
            }
            if (htmlFont.getTtf() != null || htmlFont.getSvg() != null || htmlFont.getWoff() != null) {
                sb.append("\tsrc:");
                boolean toAddComma = false;
                if (useLocal) {
                    sb.append(" local('\u263a')");
                    toAddComma = true;
                }
                if (htmlFont.getWoff() != null) {
                    String woffId;
                    String woffFileName = woffId = htmlFont.getId() + ".woff";
                    if (fontPathProvider != null) {
                        woffFileName = fontPathProvider.getResourcePath(woffId);
                    }
                    if (fontResourceSaver != null) {
                        fontResourceSaver.handleResource(woffId, this.repositoryUtil.getBytesFromLocation(htmlFont.getWoff()));
                    }
                    if (toAddComma) {
                        sb.append(",");
                    }
                    toAddComma = true;
                    sb.append("\n\t\turl('" + woffFileName + "') format('woff')");
                }
                if (htmlFont.getTtf() != null) {
                    String ttfId;
                    String ttfFileName = ttfId = htmlFont.getId() + ".ttf";
                    if (fontPathProvider != null) {
                        ttfFileName = fontPathProvider.getResourcePath(ttfId);
                    }
                    if (fontResourceSaver != null) {
                        fontResourceSaver.handleResource(ttfId, this.repositoryUtil.getBytesFromLocation(htmlFont.getTtf()));
                    }
                    if (toAddComma) {
                        sb.append(",");
                    }
                    toAddComma = true;
                    sb.append("\n\t\turl('" + ttfFileName + "') format('truetype')");
                }
                if (htmlFont.getSvg() != null) {
                    String svgId;
                    String svgFileName = svgId = htmlFont.getId() + ".svg";
                    if (fontPathProvider != null) {
                        svgFileName = fontPathProvider.getResourcePath(svgId);
                    }
                    if (fontResourceSaver != null) {
                        fontResourceSaver.handleResource(svgId, this.repositoryUtil.getBytesFromLocation(htmlFont.getSvg()));
                    }
                    if (toAddComma) {
                        sb.append(",");
                    }
                    toAddComma = true;
                    sb.append("\n\t\turl('" + svgFileName + "') format('svg')");
                }
                sb.append(";\n");
            }
            sb.append("\tfont-weight: " + (htmlFont.isBold() ? "bold" : "normal") + ";\n");
            sb.append("\tfont-style: " + (htmlFont.isItalic() ? "italic" : "normal") + ";\n");
            sb.append("}");
        }
        catch (JRException e) {
            throw new JRRuntimeException(e);
        }
        return sb.toString();
    }

    public void handleHtmlFont(HtmlResourceHandler cssResourceSaver, HtmlResourceHandler fontPathProvider, HtmlResourceHandler fontResourceSaver, HtmlFontFamily htmlFontFamily, boolean useShortId, boolean useLocal) {
        if (cssResourceSaver != null) {
            String fontCss = this.getHtmlFont(fontPathProvider, fontResourceSaver, htmlFontFamily, useShortId, useLocal);
            try {
                String cssResourceName = HtmlFontUtil.getFontCSSResourceName(htmlFontFamily);
                cssResourceSaver.handleResource(cssResourceName, fontCss.getBytes("UTF-8"));
            }
            catch (UnsupportedEncodingException e) {
                throw new JRRuntimeException(e);
            }
        }
    }

    public String getHtmlFont(HtmlResourceHandler fontPathProvider, HtmlResourceHandler fontResourceSaver, HtmlFontFamily htmlFontFamily, boolean useShortId, boolean useLocal) {
        HtmlFont htmlFont;
        StringBuilder sb = new StringBuilder();
        sb.append("@charset \"UTF-8\";\n\n");
        FontFamily fontFamily = htmlFontFamily.getFontFamily();
        FontFace fontFace = fontFamily.getNormalFace();
        if (fontFace != null) {
            htmlFont = HtmlFont.getInstance(htmlFontFamily, htmlFontFamily.getLocale(), fontFace, false, false);
            sb.append(this.getHtmlFont(fontPathProvider, fontResourceSaver, htmlFont, useShortId, useLocal));
            sb.append("\n\n");
        }
        if ((fontFace = fontFamily.getBoldFace()) != null) {
            htmlFont = HtmlFont.getInstance(htmlFontFamily, htmlFontFamily.getLocale(), fontFace, true, false);
            sb.append(this.getHtmlFont(fontPathProvider, fontResourceSaver, htmlFont, useShortId, useLocal));
            sb.append("\n\n");
        }
        if ((fontFace = fontFamily.getItalicFace()) != null) {
            htmlFont = HtmlFont.getInstance(htmlFontFamily, htmlFontFamily.getLocale(), fontFace, false, true);
            sb.append(this.getHtmlFont(fontPathProvider, fontResourceSaver, htmlFont, useShortId, useLocal));
            sb.append("\n\n");
        }
        if ((fontFace = fontFamily.getBoldItalicFace()) != null) {
            htmlFont = HtmlFont.getInstance(htmlFontFamily, htmlFontFamily.getLocale(), fontFace, true, true);
            sb.append(this.getHtmlFont(fontPathProvider, fontResourceSaver, htmlFont, useShortId, useLocal));
            sb.append("\n\n");
        }
        return sb.toString();
    }

    public static String getFontCSSResourceName(HtmlFontFamily fontFamily) {
        return fontFamily.getId() + CSS_RESOURCE_EXTENSION;
    }

    public static String getFontIdFromCSSResource(String cssResource) {
        if (cssResource == null) {
            return null;
        }
        if (cssResource.endsWith(CSS_RESOURCE_EXTENSION)) {
            return cssResource.substring(0, cssResource.length() - CSS_RESOURCE_EXTENSION.length());
        }
        return cssResource;
    }
}

