/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.util;

import java.io.BufferedOutputStream;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRRuntimeException;
import net.sf.jasperreports.engine.util.JRLoader;

public final class JRSaver {
    public static final String EXCEPTION_MESSAGE_KEY_EXPRESSIONS_CLASS_FILE_SAVE_ERROR = "util.saver.expressions.class.file.save.error";
    public static final String EXCEPTION_MESSAGE_KEY_FILE_SAVE_ERROR = "util.saver.file.save.error";
    public static final String EXCEPTION_MESSAGE_KEY_OUTPUT_STREAM_SAVE_ERROR = "util.saver.output.stream.save.error";

    public static void saveObject(Object obj, String fileName) throws JRException {
        JRSaver.saveObject(obj, new File(fileName));
    }

    public static void saveObject(Object obj, File file) throws JRException {
        try (ObjectOutputStream oos = new ObjectOutputStream(new BufferedOutputStream(new FileOutputStream(file)));){
            oos.writeObject(obj);
        }
        catch (IOException e) {
            throw new JRException(EXCEPTION_MESSAGE_KEY_FILE_SAVE_ERROR, new Object[]{file}, e);
        }
    }

    public static void saveObject(Object obj, OutputStream os) throws JRException {
        ObjectOutputStream oos = null;
        try {
            oos = new ObjectOutputStream(os);
            oos.writeObject(obj);
            oos.flush();
        }
        catch (IOException e) {
            throw new JRException(EXCEPTION_MESSAGE_KEY_OUTPUT_STREAM_SAVE_ERROR, null, e);
        }
    }

    public static void saveClassSource(String source, File file) throws JRException {
        try (BufferedWriter writer = new BufferedWriter(new FileWriter(file));){
            writer.write(source);
        }
        catch (IOException e) {
            throw new JRException(EXCEPTION_MESSAGE_KEY_EXPRESSIONS_CLASS_FILE_SAVE_ERROR, new Object[]{file}, e);
        }
    }

    public static void saveResource(String resource, File file) {
        try (FileOutputStream fos = new FileOutputStream(file);){
            fos.write(JRLoader.loadBytesFromResource(resource));
        }
        catch (IOException | JRException e) {
            throw new JRRuntimeException(e);
        }
    }

    private JRSaver() {
    }
}

