/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.hops.cost;

public class FederatedCost {
    protected double _computeCost = 0.0;
    protected double _readCost = 0.0;
    protected double _inputTransferCost = 0.0;
    protected double _outputTransferCost = 0.0;
    protected double _inputTotalCost = 0.0;

    public FederatedCost() {
    }

    public FederatedCost(double readCost, double inputTransferCost, double outputTransferCost, double computeCost, double inputTotalCost) {
        this._readCost = readCost;
        this._inputTransferCost = inputTransferCost;
        this._outputTransferCost = outputTransferCost;
        this._computeCost = computeCost;
        this._inputTotalCost = inputTotalCost;
    }

    public double getTotal() {
        return this._computeCost + this._readCost + this._inputTransferCost + this._outputTransferCost + this._inputTotalCost;
    }

    public void addRepetitionCost(int repetitionNumber) {
        this._inputTotalCost *= (double)repetitionNumber;
    }

    public double getInputTotalCost() {
        return this._inputTotalCost;
    }

    public void setInputTotalCost(double inputTotalCost) {
        this._inputTotalCost = inputTotalCost;
    }

    public void addInputTotalCost(double additionalCost) {
        this._inputTotalCost += additionalCost;
    }

    public void addInputTotalCost(FederatedCost federatedCost) {
        this._inputTotalCost += federatedCost.getTotal();
    }

    public void addFederatedCost(FederatedCost additionalCost) {
        this._readCost += additionalCost._readCost;
        this._inputTransferCost += additionalCost._inputTransferCost;
        this._outputTransferCost += additionalCost._outputTransferCost;
        this._computeCost += additionalCost._computeCost;
        this._inputTotalCost += additionalCost._inputTotalCost;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(" computeCost: ");
        builder.append(this._computeCost);
        builder.append("\n readCost: ");
        builder.append(this._readCost);
        builder.append("\n inputTransferCost: ");
        builder.append(this._inputTransferCost);
        builder.append("\n outputTransferCost: ");
        builder.append(this._outputTransferCost);
        builder.append("\n inputTotalCost: ");
        builder.append(this._inputTotalCost);
        builder.append("\n total cost: ");
        builder.append(this.getTotal());
        return builder.toString();
    }
}

