/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.compress.cost;

import java.io.Serializable;

public final class InstructionTypeCounter
implements Serializable {
    private static final long serialVersionUID = 115L;
    protected int scans = 0;
    protected int decompressions = 0;
    protected int overlappingDecompressions = 0;
    protected int leftMultiplications = 0;
    protected int rightMultiplications = 0;
    protected int compressedMultiplications = 0;
    protected int dictionaryOps = 0;
    protected int indexing = 0;
    protected boolean isDensifying = false;

    protected InstructionTypeCounter() {
    }

    public int getScans() {
        return this.scans;
    }

    public int getDecompressions() {
        return this.decompressions;
    }

    public int getOverlappingDecompressions() {
        return this.overlappingDecompressions;
    }

    public int getLeftMultipications() {
        return this.leftMultiplications;
    }

    public int getRightMultiplications() {
        return this.rightMultiplications;
    }

    public int getCompressedMultiplications() {
        return this.compressedMultiplications;
    }

    public int getDictionaryOps() {
        return this.dictionaryOps;
    }

    public int getIndexing() {
        return this.indexing;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(String.format("\nscans                     :%4d", this.scans));
        sb.append(String.format("\ndecompressions            :%4d", this.decompressions));
        sb.append(String.format("\noverlappingDecompressions :%4d", this.overlappingDecompressions));
        sb.append(String.format("\nleftMultiplications       :%4d", this.leftMultiplications));
        sb.append(String.format("\nrightMultiplications      :%4d", this.rightMultiplications));
        sb.append(String.format("\ncompressedMultiplications :%4d", this.compressedMultiplications));
        sb.append(String.format("\ndictionaryOps             :%4d", this.dictionaryOps));
        sb.append(String.format("\nindexing                  :%4d", this.indexing));
        return sb.toString();
    }
}

