/*
 * Decompiled with CFR 0.152.
 */
package org.spark_project.jetty.server;

import java.util.Enumeration;
import java.util.List;
import java.util.StringTokenizer;
import org.spark_project.jetty.util.LazyList;
import org.spark_project.jetty.util.log.Log;
import org.spark_project.jetty.util.log.Logger;

public class InclusiveByteRange {
    private static final Logger LOG = Log.getLogger(InclusiveByteRange.class);
    long first = 0L;
    long last = 0L;

    public InclusiveByteRange(long first2, long last) {
        this.first = first2;
        this.last = last;
    }

    public long getFirst() {
        return this.first;
    }

    public long getLast() {
        return this.last;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static List<InclusiveByteRange> satisfiableRanges(Enumeration<String> headers2, long size) {
        Object satRanges = null;
        block4: while (headers2.hasMoreElements()) {
            String header = headers2.nextElement();
            StringTokenizer tok = new StringTokenizer(header, "=,", false);
            String t = null;
            try {
                while (true) {
                    if (!tok.hasMoreTokens()) continue block4;
                    try {
                        long last;
                        long first2;
                        block13: {
                            t = tok.nextToken().trim();
                            first2 = -1L;
                            last = -1L;
                            int d = t.indexOf(45);
                            if (d < 0 || t.indexOf("-", d + 1) >= 0) {
                                if ("bytes".equals(t)) continue;
                                LOG.warn("Bad range format: {}", t);
                                continue block4;
                            }
                            if (d == 0) {
                                if (d + 1 < t.length()) {
                                    last = Long.parseLong(t.substring(d + 1).trim());
                                    break block13;
                                } else {
                                    LOG.warn("Bad range format: {}", t);
                                    continue;
                                }
                            }
                            if (d + 1 < t.length()) {
                                first2 = Long.parseLong(t.substring(0, d).trim());
                                last = Long.parseLong(t.substring(d + 1).trim());
                            } else {
                                first2 = Long.parseLong(t.substring(0, d).trim());
                            }
                        }
                        if (first2 == -1L && last == -1L || first2 != -1L && last != -1L && first2 > last) continue block4;
                        if (first2 >= size) continue;
                        InclusiveByteRange range2 = new InclusiveByteRange(first2, last);
                        satRanges = LazyList.add(satRanges, range2);
                    }
                    catch (NumberFormatException e) {
                        LOG.warn("Bad range format: {}", t);
                        LOG.ignore(e);
                    }
                }
            }
            catch (Exception e) {
                LOG.warn("Bad range format: {}", t);
                LOG.ignore(e);
                continue;
            }
            break;
        }
        return LazyList.getList(satRanges, true);
    }

    public long getFirst(long size) {
        if (this.first < 0L) {
            long tf = size - this.last;
            if (tf < 0L) {
                tf = 0L;
            }
            return tf;
        }
        return this.first;
    }

    public long getLast(long size) {
        if (this.first < 0L) {
            return size - 1L;
        }
        if (this.last < 0L || this.last >= size) {
            return size - 1L;
        }
        return this.last;
    }

    public long getSize(long size) {
        return this.getLast(size) - this.getFirst(size) + 1L;
    }

    public String toHeaderRangeString(long size) {
        StringBuilder sb = new StringBuilder(40);
        sb.append("bytes ");
        sb.append(this.getFirst(size));
        sb.append('-');
        sb.append(this.getLast(size));
        sb.append("/");
        sb.append(size);
        return sb.toString();
    }

    public static String to416HeaderRangeString(long size) {
        StringBuilder sb = new StringBuilder(40);
        sb.append("bytes */");
        sb.append(size);
        return sb.toString();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(60);
        sb.append(Long.toString(this.first));
        sb.append(":");
        sb.append(Long.toString(this.last));
        return sb.toString();
    }
}

