/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.shuffle;

import java.io.File;
import org.apache.spark.Partition;
import org.apache.spark.ShuffleDependency;
import org.apache.spark.SparkEnv$;
import org.apache.spark.TaskContext;
import org.apache.spark.internal.Logging;
import org.apache.spark.rdd.RDD;
import org.apache.spark.scheduler.MapStatus;
import org.apache.spark.shuffle.IndexShuffleBlockResolver;
import org.apache.spark.shuffle.ShuffleBlockPusher;
import org.apache.spark.shuffle.ShuffleBlockResolver;
import org.apache.spark.shuffle.ShuffleManager;
import org.apache.spark.shuffle.ShuffleWriteMetricsReporter;
import org.apache.spark.shuffle.ShuffleWriter;
import org.slf4j.Logger;
import scala.Function0;
import scala.Option;
import scala.Serializable;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0001\t4Q\u0001B\u0003\u0001\u000f5AQ!\b\u0001\u0005\u0002}AQA\t\u0001\u0005\u0012\rBQ!\f\u0001\u0005\u00029\u0012Qc\u00155vM\u001adWm\u0016:ji\u0016\u0004&o\\2fgN|'O\u0003\u0002\u0007\u000f\u000591\u000f[;gM2,'B\u0001\u0005\n\u0003\u0015\u0019\b/\u0019:l\u0015\tQ1\"\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002\u0019\u0005\u0019qN]4\u0014\t\u0001qAc\u0006\t\u0003\u001fIi\u0011\u0001\u0005\u0006\u0002#\u0005)1oY1mC&\u00111\u0003\u0005\u0002\u0007\u0003:L(+\u001a4\u0011\u0005=)\u0012B\u0001\f\u0011\u00051\u0019VM]5bY&T\u0018M\u00197f!\tA2$D\u0001\u001a\u0015\tQr!\u0001\u0005j]R,'O\\1m\u0013\ta\u0012DA\u0004M_\u001e<\u0017N\\4\u0002\rqJg.\u001b;?\u0007\u0001!\u0012\u0001\t\t\u0003C\u0001i\u0011!B\u0001\u0016GJ,\u0017\r^3NKR\u0014\u0018nY:SKB|'\u000f^3s)\t!s\u0005\u0005\u0002\"K%\u0011a%\u0002\u0002\u001c'\",hM\u001a7f/JLG/Z'fiJL7m\u001d*fa>\u0014H/\u001a:\t\u000b!\u0012\u0001\u0019A\u0015\u0002\u000f\r|g\u000e^3yiB\u0011!fK\u0007\u0002\u000f%\u0011Af\u0002\u0002\f)\u0006\u001c8nQ8oi\u0016DH/A\u0003xe&$X\r\u0006\u00040k!;F,\u0018\t\u0003aMj\u0011!\r\u0006\u0003e\u001d\t\u0011b]2iK\u0012,H.\u001a:\n\u0005Q\n$!C'baN#\u0018\r^;t\u0011\u001514\u00011\u00018\u0003\r\u0011H\r\u001a\u0019\u0003q}\u00022!O\u001e>\u001b\u0005Q$B\u0001\u001c\b\u0013\ta$HA\u0002S\t\u0012\u0003\"AP \r\u0001\u0011I\u0001)NA\u0001\u0002\u0003\u0015\t!\u0011\u0002\u0004?\u0012\n\u0014C\u0001\"F!\ty1)\u0003\u0002E!\t9aj\u001c;iS:<\u0007CA\bG\u0013\t9\u0005CA\u0002B]fDQ!S\u0002A\u0002)\u000b1\u0001Z3qa\u0011YuJU+\u0011\u000b)be*\u0015+\n\u00055;!!E*ik\u001a4G.\u001a#fa\u0016tG-\u001a8dsB\u0011ah\u0014\u0003\n!\"\u000b\t\u0011!A\u0003\u0002\u0005\u00131a\u0018\u00133!\tq$\u000bB\u0005T\u0011\u0006\u0005\t\u0011!B\u0001\u0003\n\u0019q\fJ\u001a\u0011\u0005y*F!\u0003,I\u0003\u0003\u0005\tQ!\u0001B\u0005\ryF\u0005\u000e\u0005\u00061\u000e\u0001\r!W\u0001\u0006[\u0006\u0004\u0018\n\u001a\t\u0003\u001fiK!a\u0017\t\u0003\t1{gn\u001a\u0005\u0006Q\r\u0001\r!\u000b\u0005\u0006=\u000e\u0001\raX\u0001\na\u0006\u0014H/\u001b;j_:\u0004\"A\u000b1\n\u0005\u0005<!!\u0003)beRLG/[8o\u0001")
public class ShuffleWriteProcessor
implements Serializable,
Logging {
    private transient Logger org$apache$spark$internal$Logging$$log_;

    @Override
    public String logName() {
        return Logging.logName$(this);
    }

    @Override
    public Logger log() {
        return Logging.log$(this);
    }

    @Override
    public void logInfo(Function0<String> msg) {
        Logging.logInfo$(this, msg);
    }

    @Override
    public void logDebug(Function0<String> msg) {
        Logging.logDebug$(this, msg);
    }

    @Override
    public void logTrace(Function0<String> msg) {
        Logging.logTrace$(this, msg);
    }

    @Override
    public void logWarning(Function0<String> msg) {
        Logging.logWarning$(this, msg);
    }

    @Override
    public void logError(Function0<String> msg) {
        Logging.logError$(this, msg);
    }

    @Override
    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$(this, msg, throwable);
    }

    @Override
    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$(this, msg, throwable);
    }

    @Override
    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$(this, msg, throwable);
    }

    @Override
    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$(this, msg, throwable);
    }

    @Override
    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$(this, msg, throwable);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$(this, isInterpreter);
    }

    @Override
    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$(this, isInterpreter, silent);
    }

    @Override
    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$(this);
    }

    @Override
    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$(this, isInterpreter, silent);
    }

    @Override
    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    @Override
    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public ShuffleWriteMetricsReporter createMetricsReporter(TaskContext context) {
        return context.taskMetrics().shuffleWriteMetrics();
    }

    public MapStatus write(RDD<?> rdd, ShuffleDependency<?, ?, ?> dep, long mapId, TaskContext context, Partition partition) {
        MapStatus mapStatus;
        ShuffleWriter writer = null;
        try {
            ShuffleManager manager = SparkEnv$.MODULE$.get().shuffleManager();
            writer = manager.getWriter(dep.shuffleHandle(), mapId, context, this.createMetricsReporter(context));
            writer.write(rdd.iterator(partition, context));
            Option<MapStatus> mapStatus2 = writer.stop(true);
            if (mapStatus2.isDefined() && dep.shuffleMergeEnabled() && dep.getMergerLocs().nonEmpty() && !dep.shuffleMergeFinalized()) {
                ShuffleBlockResolver shuffleBlockResolver = manager.shuffleBlockResolver();
                if (shuffleBlockResolver instanceof IndexShuffleBlockResolver) {
                    IndexShuffleBlockResolver indexShuffleBlockResolver = (IndexShuffleBlockResolver)shuffleBlockResolver;
                    File dataFile = indexShuffleBlockResolver.getDataFile(dep.shuffleId(), mapId);
                    new ShuffleBlockPusher(SparkEnv$.MODULE$.get().conf()).initiateBlockPush(dataFile, writer.getPartitionLengths(), dep, partition.index());
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                } else {
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                }
            }
            mapStatus = (MapStatus)mapStatus2.get();
        }
        catch (Exception e) {
            BoxedUnit boxedUnit;
            try {
                boxedUnit = writer != null ? writer.stop(false) : BoxedUnit.UNIT;
            }
            catch (Exception e2) {
                this.log().debug("Could not stop writer", (Throwable)e2);
                boxedUnit = BoxedUnit.UNIT;
            }
            throw e;
        }
        return mapStatus;
    }

    public ShuffleWriteProcessor() {
        Logging.$init$(this);
    }
}

