/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.lops;

import org.apache.sysds.common.Types;
import org.apache.sysds.lops.Data;
import org.apache.sysds.lops.Lop;

public class Ctable
extends Lop {
    private final boolean _ignoreZeros;
    private final boolean _outputEmptyBlocks;
    OperationTypes operation;

    public Ctable(Lop[] inputLops, OperationTypes op, Types.DataType dt, Types.ValueType vt, Types.ExecType et) {
        this(inputLops, op, dt, vt, false, true, et);
    }

    public Ctable(Lop[] inputLops, OperationTypes op, Types.DataType dt, Types.ValueType vt, boolean ignoreZeros, boolean outputEmptyBlocks, Types.ExecType et) {
        super(Lop.Type.Ctable, dt, vt);
        this.init(inputLops, op, et);
        this._ignoreZeros = ignoreZeros;
        this._outputEmptyBlocks = outputEmptyBlocks;
    }

    private void init(Lop[] inputLops, OperationTypes op, Types.ExecType et) {
        this.operation = op;
        for (int i = 0; i < inputLops.length; ++i) {
            this.addInput(inputLops[i]);
            inputLops[i].addOutput(this);
        }
        this.lps.setProperties(this.inputs, et);
    }

    @Override
    public String toString() {
        return " Operation: " + this.operation;
    }

    public static OperationTypes findCtableOperationByInputDataTypes(Types.DataType dt1, Types.DataType dt2, Types.DataType dt3) {
        if (dt1 == Types.DataType.MATRIX) {
            if (dt2 == Types.DataType.MATRIX && dt3 == Types.DataType.SCALAR) {
                return OperationTypes.CTABLE_TRANSFORM_SCALAR_WEIGHT;
            }
            if (dt2 == Types.DataType.SCALAR && dt3 == Types.DataType.SCALAR) {
                return OperationTypes.CTABLE_TRANSFORM_HISTOGRAM;
            }
            if (dt2 == Types.DataType.SCALAR && dt3 == Types.DataType.MATRIX) {
                return OperationTypes.CTABLE_TRANSFORM_WEIGHTED_HISTOGRAM;
            }
            return OperationTypes.CTABLE_TRANSFORM;
        }
        return OperationTypes.INVALID;
    }

    public OperationTypes getOperationType() {
        return this.operation;
    }

    @Override
    public String getInstructions(String input1, String input2, String input3, String output) {
        StringBuilder sb = new StringBuilder();
        sb.append((Object)this.getExecType());
        sb.append("\u00b0");
        if (this.operation != OperationTypes.CTABLE_EXPAND_SCALAR_WEIGHT) {
            sb.append("ctable");
        } else {
            sb.append("ctableexpand");
        }
        sb.append("\u00b0");
        sb.append(this.getInputs().get(0).getDataType() == Types.DataType.SCALAR ? this.getInputs().get(0).prepScalarInputOperand(this.getExecType()) : this.getInputs().get(0).prepInputOperand(input1));
        sb.append("\u00b0");
        sb.append(this.getInputs().get(1).getDataType() == Types.DataType.SCALAR ? this.getInputs().get(1).prepScalarInputOperand(this.getExecType()) : this.getInputs().get(1).prepInputOperand(input2));
        sb.append("\u00b0");
        sb.append(this.getInputs().get(2).getDataType() == Types.DataType.SCALAR ? this.getInputs().get(2).prepScalarInputOperand(this.getExecType()) : this.getInputs().get(2).prepInputOperand(input3));
        sb.append("\u00b0");
        if (this.getInputs().size() > 3) {
            sb.append(this.getInputs().get(3).getOutputParameters().getLabel());
            sb.append("\u00b7");
            sb.append(this.getInputs().get(3).getType() == Lop.Type.Data && ((Data)this.getInputs().get(3)).isLiteral());
            sb.append("\u00b0");
            sb.append(this.getInputs().get(4).getOutputParameters().getLabel());
            sb.append("\u00b7");
            sb.append(this.getInputs().get(4).getType() == Lop.Type.Data && ((Data)this.getInputs().get(4)).isLiteral());
            sb.append("\u00b0");
        } else {
            sb.append(-1);
            sb.append("\u00b7");
            sb.append(true);
            sb.append("\u00b0");
            sb.append(-1);
            sb.append("\u00b7");
            sb.append(true);
            sb.append("\u00b0");
        }
        sb.append(this.prepOutputOperand(output));
        sb.append("\u00b0");
        sb.append(this._ignoreZeros);
        if (this.getExecType() == Types.ExecType.SPARK) {
            sb.append("\u00b0");
            sb.append(this._outputEmptyBlocks);
        }
        return sb.toString();
    }

    public static OperationTypes getOperationType(String opcode) {
        OperationTypes op = null;
        if (opcode.equals("ctabletransform")) {
            op = OperationTypes.CTABLE_TRANSFORM;
        } else if (opcode.equals("ctabletransformscalarweight")) {
            op = OperationTypes.CTABLE_TRANSFORM_SCALAR_WEIGHT;
        } else if (opcode.equals("ctableexpandscalarweight")) {
            op = OperationTypes.CTABLE_EXPAND_SCALAR_WEIGHT;
        } else if (opcode.equals("ctabletransformhistogram")) {
            op = OperationTypes.CTABLE_TRANSFORM_HISTOGRAM;
        } else if (opcode.equals("ctabletransformweightedhistogram")) {
            op = OperationTypes.CTABLE_TRANSFORM_WEIGHTED_HISTOGRAM;
        } else {
            throw new UnsupportedOperationException("Tertiary operation code is not defined: " + opcode);
        }
        return op;
    }

    public static enum OperationTypes {
        CTABLE_TRANSFORM,
        CTABLE_TRANSFORM_SCALAR_WEIGHT,
        CTABLE_TRANSFORM_HISTOGRAM,
        CTABLE_TRANSFORM_WEIGHTED_HISTOGRAM,
        CTABLE_EXPAND_SCALAR_WEIGHT,
        INVALID;


        public boolean hasSecondInput() {
            return this == CTABLE_TRANSFORM || this == CTABLE_EXPAND_SCALAR_WEIGHT || this == CTABLE_TRANSFORM_SCALAR_WEIGHT;
        }

        public boolean hasThirdInput() {
            return this == CTABLE_TRANSFORM || this == CTABLE_TRANSFORM_WEIGHTED_HISTOGRAM;
        }
    }
}

